% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_mc_css.R
\name{calc_mc_css}
\alias{calc_mc_css}
\title{Find the monte carlo steady state concentration.}
\usage{
calc_mc_css(chem.cas = NULL, chem.name = NULL, parameters = NULL,
  daily.dose = 1, which.quantile = 0.95, species = "Human",
  output.units = "mg/L", suppress.messages = F,
  model = "3compartmentss", censored.params = list(Funbound.plasma =
  list(cv = 0.3, lod = 0.01)), vary.params = list(BW = 0.3, Vliverc =
  0.3, Qgfrc = 0.3, Qtotal.liverc = 0.3, million.cells.per.gliver = 0.3,
  Clint = 0.3), fup.meas.cv = 0.4, clint.meas.cv = 0.3,
  fup.pop.cv = 0.3, clint.pop.cv = 0.3, samples = 1000,
  return.samples = F, default.to.human = F, tissue = NULL,
  well.stirred.correction = T, adjusted.Funbound.plasma = T,
  regression = T, clint.pvalue.threshold = 0.05,
  restrictive.clearance = T, bioactive.free.invivo = FALSE,
  concentration = "plasma", IVIVE = NULL, httkpop = T,
  poormetab = T, fup.censored.dist = FALSE, fup.lod = 0.01,
  method = "direct resampling", gendernum = NULL,
  agelim_years = NULL, agelim_months = NULL,
  weight_category = c("Underweight", "Normal", "Overweight", "Obese"),
  gfr_category = c("Normal", "Kidney Disease", "Kidney Failure"),
  reths = c("Mexican American", "Other Hispanic", "Non-Hispanic White",
  "Non-Hispanic Black", "Other"), physiology.matrix = NULL,
  parameter.matrix = NULL, ...)
}
\arguments{
\item{chem.cas}{Either the CAS number, parameters, or the chemical name must
be specified.}

\item{chem.name}{Either the chemical parameters, name, or the CAS number
must be specified.}

\item{parameters}{Parameters from parameterize_steadystate. Not used with
httkpop model.}

\item{daily.dose}{Total daily dose, mg/kg BW/day.}

\item{which.quantile}{Which quantile from Monte Carlo simulation is
requested. Can be a vector.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").  Species must be set to "Human" to run httkpop model.}

\item{output.units}{Plasma concentration units, either uM or default mg/L.}

\item{suppress.messages}{Whether or not to suppress output message.}

\item{model}{Model used in calculation: 'pbtk' for the multiple compartment
model,'3compartment' for the three compartment model, '3compartmentss' for
the three compartment steady state model, and '1compartment' for one
compartment model.  This only applies when httkpop=TRUE and species="Human",
otherwise '3compartmentss' is used.}

\item{censored.params}{The parameters listed in censored.params are sampled
from a normal distribution that is censored for values less than the limit
of detection (specified separately for each paramter). This argument should
be a list of sub-lists. Each sublist is named for a parameter in
"parameters" and contains two elements: "CV" (coefficient of variation) and
"LOD" (limit of detection, below which parameter values are censored. New
values are sampled with mean equal to the value in "parameters" and standard
deviation equal to the mean times the CV.  Censored values are sampled on a
uniform distribution between 0 and the limit of detection. Not used with
httkpop model.}

\item{vary.params}{The parameters listed in vary.params are sampled from a
normal distribution that is truncated at zero. This argument should be a
list of coefficients of variation (CV) for the normal distribution. Each
entry in the list is named for a parameter in "parameters". New values are
sampled with mean equal to the value in "parameters" and standard deviation
equal to the mean times the CV. Not used with httkpop model.}

\item{fup.meas.cv}{Coefficient of variation of distribution of measured
\code{Funbound.plasma} values.}

\item{clint.meas.cv}{Coefficient of variation of distribution of measured 
\code{Clint} values.}

\item{fup.pop.cv}{Coefficient of variation of distribution of population
\code{Funbound.plasma} values.}

\item{clint.pop.cv}{Coefficient of variation of distribution of population
\code{Clint} values.}

\item{samples}{Number of samples generated in calculating quantiles.}

\item{return.samples}{Whether or not to return the vector containing the
samples from the simulation instead of the selected quantile.}

\item{default.to.human}{Substitutes missing rat values with human values if
true.}

\item{tissue}{Desired steady state tissue conentration.}

\item{well.stirred.correction}{If TRUE (default) then the well-stirred
correction (Rowland et al., 1973) is used in the calculation of hepatic
clearance for the models that do not include flows for first-pass metabolism
(currently, 1compartment and 3compartmentss). This assumes clearance
relative to amount unbound in whole blood instead of plasma, but converted
for use with plasma concentration.}

\item{adjusted.Funbound.plasma}{Uses adjusted Funbound.plasma when set to
TRUE along with partition coefficients calculated with this value.}

\item{regression}{Whether or not to use the regressions in calculating
partition coefficients.}

\item{clint.pvalue.threshold}{Hepatic clearance for chemicals where the in
vitro clearance assay result has a p-values greater than the threshold are
set to zero.}

\item{restrictive.clearance}{Protein binding not taken into account (set to
1) in liver clearance if FALSE.}

\item{bioactive.free.invivo}{If FALSE (default), then the total concentration is treated
as bioactive in vivo. If TRUE, the the unbound (free) plasma concentration is treated as 
bioactive in vivo. Only works with tissue = NULL in current implementation.}

\item{concentration}{Desired concentration type, 'blood','tissue', or default 'plasma'.}

\item{IVIVE}{Honda et al. (2019) identified six plausible sets of
assumptions for \emph{in vitro-in vivo} extrapolation (IVIVE) assumptions.
Argument may be set to "Honda1" through "Honda6". If used, this function
overwrites the tissue, restrictive.clearance, and plasma.binding arguments.
See Details below for more information.}

\item{httkpop}{Whether or not to use population generator and sampler from
httkpop.  This is overwrites censored.params and vary.params and is only for
human physiology.  Species must also be set to 'Human'.}

\item{poormetab}{TRUE (include poor metabolizers) or FALSE (exclude poor
metabolizers)}

\item{fup.censored.dist}{Logical. Whether to draw \code{Funbound.plasma} from a
censored distribution or not.}

\item{fup.lod}{The average limit of detection for Funbound.plasma. if
\code{fup.censor == TRUE}, the \code{Funbound.plasma} distribution will be
censored below \code{lod/2}. Default value is 0.01.}

\item{method}{The population-generation method to use. Either "virtual
individuals" or "direct resampling" (default). Short names may be used: "d"
or "dr" for "direct resampling", and "v" or "vi" for "virtual individuals".}

\item{gendernum}{Optional: A named list giving the numbers of male and
female individuals to include in the population, e.g. \code{list(Male=100,
Female=100)}. Default is NULL, meaning both males and females are included,
in their proportions in the NHANES data. If both \code{nsamp} and
\code{gendernum} are provided, they must agree (i.e., \code{nsamp} must be
the sum of \code{gendernum}).}

\item{agelim_years}{Optional: A two-element numeric vector giving the
minimum and maximum ages (in years) to include in the population. Default is
c(0,79). If only a single value is provided, both minimum and maximum ages
will be set to that value; e.g. \code{agelim_years=3} is equivalent to
\code{agelim_years=c(3,3)}. If \code{agelim_years} is provided and
\code{agelim_months} is not, \code{agelim_years} will override the default
value of \code{agelim_months}.}

\item{agelim_months}{Optional: A two-element numeric vector giving the
minimum and maximum ages (in months) to include in the population. Default
is c(0, 959), equivalent to the default \code{agelim_years}. If only a
single value is provided, both minimum and maximum ages will be set to that
value; e.g. \code{agelim_months=36} is equivalent to
\code{agelim_months=c(36,36)}. If \code{agelim_months} is provided and
\code{agelim_years} is not, \code{agelim_months} will override the default
values of \code{agelim_years}.}

\item{weight_category}{Optional: The weight categories to include in the
population. Default is \code{c('Underweight', 'Normal', 'Overweight',
'Obese')}. User-supplied vector must contain one or more of these strings.}

\item{gfr_category}{The kidney function categories to include in the
population. Default is \code{c('Normal','Kidney Disease', 'Kidney Failure')}
to include all kidney function levels.}

\item{reths}{Optional: a character vector giving the races/ethnicities to
include in the population. Default is \code{c('Mexican American','Other
Hispanic','Non-Hispanic White','Non-Hispanic Black','Other')}, to include
all races and ethnicities in their proportions in the NHANES data.
User-supplied vector must contain one or more of these strings.}

\item{physiology.matrix}{A data table generated by
\code{httkpop_generate()}.}

\item{parameter.matrix}{A data table generated by \code{get_httk_params()}.}

\item{...}{Additional parameters passed to calc_analytic_css}
}
\description{
This function finds the analytical steady state plasma concentration(from
calc_analytic_css) using a monte carlo simulation (monte_carlo).
}
\details{
All arguments after httkpop only apply if httkpop is set to TRUE and species
to "Human".

When species is specified as rabbit, dog, or mouse, the function uses the
appropriate physiological data(volumes and flows) but substitues human
fraction unbound, partition coefficients, and intrinsic hepatic clearance.

Tissue concentrations are calculated for the pbtk model with oral infusion
dosing.  All tissues other than gut, liver, and lung are the product of the
steady state plasma concentration and the tissue to plasma partition
coefficient.

The six sets of plausible \emph{in vitro-in vivo} extrpolation (IVIVE)
assumptions identified by Honda et al. (2019) are: \tabular{lrrrr}{
\tab \emph{in vivo} Conc. \tab Metabolic Clearance \tab Bioactive Chemical
Conc. \tab TK Statistic Used* \cr Honda1 \tab Veinous (Plasma) \tab
Restrictive \tab Free \tab Mean Conc. \cr Honda2 \tab Veinous \tab
Restrictive \tab Free \tab Max Conc. \cr Honda3 \tab Veinous \tab
Non-restrictive \tab Total \tab Mean Conc. \cr Honda4 \tab Veinous \tab
Non-restrictive \tab Total \tab Max Conc. \cr Honda5 \tab Target Tissue \tab
Non-restrictive \tab Total \tab Mean Conc. \cr Honda6 \tab Target Tissue
\tab Non-restrictive \tab Total \tab Max Conc. \cr } *Assumption is
currently ignored because analytical steady-state solutions are currently
used by this function.
}
\examples{

\dontrun{
 calc_mc_css(chem.name='Bisphenol A',output.units='uM',method='vi',
             samples=100,return.samples=TRUE)
 calc_mc_css(chem.name='2,4-d',which.quantile=.9,httkpop=FALSE,tissue='heart')

 calc_mc_css(chem.cas = "80-05-7", daily.dose = 1, which.quantile = 0.5,
             censored.params = list(Funbound.plasma = list(cv = 0.1, 
                                                          lod = 0.005)),
             vary.params = list(BW = 0.15, Vliverc = 0.15, Qgfrc = 0.15,
                               Qtotal.liverc = 0.15, 
                               million.cells.per.gliver = 0.15, Clint = 0.15),
             output.units = "uM", samples = 2000)

 params <- parameterize_pbtk(chem.cas="80-05-7")
 calc_mc_css(parameters=params,model="pbtk")
}

}
\references{
Wambaugh, John F., et al. "Toxicokinetic triage for 
environmental chemicals." Toxicological Sciences 147.1 (2015): 55-67.

Ring, Caroline L., et al. "Identifying populations sensitive to
environmental chemicals by simulating toxicokinetic variability."
Environment international 106 (2017): 105-118. 

Honda, Gregory S., et al. "Using the Concordance of In Vitro and 
In Vivo Data to Evaluate Extrapolation Assumptions." 2019. PLoS ONE 14(5): e0217564.

Rowland, Malcolm, Leslie Z. Benet, and Garry G. Graham. "Clearance concepts in 
pharmacokinetics." Journal of pharmacokinetics and biopharmaceutics 1.2 (1973): 123-136.
}
\author{
Caroline Ring, Robert Pearce, and John Wambaugh
}
\keyword{Carlo}
\keyword{Monte}
\keyword{State}
\keyword{Steady}
