% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/htmltab.R
\name{htmltab}
\alias{htmltab}
\title{Robust methods for extracting structured information out of HTML tables}
\usage{
htmltab(doc, which = NULL, header = NULL, headerSep = " >> ",
  fillNA = c(""), body = NULL, bodyFun = function(node)
  XML::xmlValue(node), headerFun = function(node) XML::xmlValue(node),
  rm_superscript = T, rm_escape = " ", rm_footnotes = T,
  rm_nodata_cols = T, rm_invisible = T, colNames = NULL, ...)
}
\arguments{
\item{doc}{the HTML document which can be a file name or a URL or an already parsed document
(by XML's parsing functions)}

\item{which}{a vector of length one for identification of the table in the document. Either a
numeric vector for the tables' rank or a character vector that describes an XPath for the table}

\item{header}{a vector that contains information for the identification of the header row(s).
A numeric vector can be specified where each element corresponds to the table rows. A character
vector may be specified that describes an XPath for the header rows. If left unspecified, htmltab
tries to use semantic information from the HTML code}

\item{headerSep}{a character vector that is used as a seperator in the construction of the table's
variable names (default ' >> ')}

\item{fillNA}{character vector of symbols that are replaced by NA. Set to NULL to disable
(default c(''))}

\item{body}{a vector that specifies which table rows should be used as body information. A numeric
vector can be specified where each element corresponds to a table row. A character vector may be
specified that describes an XPath for the body rows. If left unspecified, htmltab tries to use
semantic information from the HTML code}

\item{bodyFun}{a function that is executed over the body cell nodes}

\item{headerFun}{a function that is executed over the header cell nodes}

\item{rm_superscript}{logical, should superscript information be removed from header and body cells
(default TRUE)?}

\item{rm_escape}{a character vector that, if specified, is used to replace escape sequences in header
and body cells (default ' ')}

\item{rm_footnotes}{logical, should semantic footer information be removed (default TRUE)?}

\item{rm_nodata_cols}{logical, should columns that have no alphanumeric data be removed?}

\item{rm_invisible}{logical, should nodes that are not visible be removed (default TRUE)?}

\item{colNames}{a character vector of column names, or a function that can be used to replace specific
column names (default NULL)}

\item{...}{additional arguments passed to parsing functions}
}
\value{
An R data frame
}
\description{
Robust methods for extracting structured information out of HTML tables
}
\examples{
# When no spans are present, htmltab produces output identical to XML's readHTMLTable()

 url <- "http://en.wikipedia.org/wiki/World_population"
 xp <- "//caption[starts-with(text(),'World historical')]/ancestor::table"
 htmltab(doc = url, which = xp)

 popFun <- function(node) {
   x <- XML::xmlValue(node)
   gsub(',', '', x)
 }

 htmltab(doc = url, which = xp, bodyFun = popFun)

#This table lacks header information. We provide them through colNames.
#We also need to set header = 0 to indicate that no header is present.
doc <- "http://en.wikipedia.org/wiki/FC_Bayern_Munich"
xp2 <- "//td[text() = 'Head coach']/ancestor::table"
htmltab(doc = doc, which = xp2, header = 0, encoding = "UTF-8", colNames = c("name", "role"))

#htmltab recognizes column spans and produces a one-dimension vector of variable information,
#also removes automatically superscript information since these are usually not of use.

 doc <- "http://en.wikipedia.org/wiki/Usage_share_of_web_browsers"
 xp3 <-  "//table[6]"
 bFun <- function(node) {
   x <- XML::xmlValue(node)
   gsub('\%$', '', x)
 }

 htmltab(doc = doc, which = xp3, bodyFun = bFun)
}

