% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_multcomp.R
\name{mc_multcomp}
\alias{mc_multcomp}
\title{Multiple comparisons test for each response.}
\usage{
mc_multcomp(object, effect, data, verbose = TRUE)
}
\arguments{
\item{object}{An object of \code{mcglm} class.}

\item{effect}{A list of vector of variables. For each configuration
of these the estimate will be calculated.}

\item{data}{Data frame with the dataset used in the model.}

\item{verbose}{a logical if TRUE print some information about the
tests performed. Default verbose = TRUE.}
}
\value{
Table of multiple comparisons.
}
\description{
Performs a multiple comparisons test to compare
diferences between treatment levels for each response for model
objects produced by mcglm.
}
\examples{

library(mcglm)
library(Matrix)
library(htmcglm)

data("soya", package = "mcglm")

form.grain <- grain ~ water * pot
form.seed <- seeds ~ water * pot

soya$viablepeasP <- soya$viablepeas / soya$totalpeas
form.peas <- viablepeasP ~ water * pot

Z0 <- mc_id(soya)
Z1 <- mc_mixed(~0 + factor(block), data = soya)

fit_joint <- mcglm(linear_pred = c(form.grain,
                                   form.seed,
                                   form.peas),
                   matrix_pred = list(c(Z0, Z1),
                                      c(Z0, Z1),
                                      c(Z0, Z1)),
                   link = c("identity",
                            "log",
                            "logit"),
                   variance = c("constant",
                                "tweedie",
                                "binomialP"),
                   Ntrial = list(NULL,
                                 NULL,
                                 soya$totalpeas),
                   power_fixed = c(TRUE,TRUE,TRUE),
                   data = soya)

mc_multcomp(object = fit_joint,
            effect = list(c('water'),
                          c('water'),
                          c('water')),
            data = soya)

mc_multcomp(object = fit_joint,
            effect = list(c('pot'),
                          c('pot'),
                          c('pot')),
            data = soya)


mc_multcomp(object = fit_joint,
            effect = list(c('water', 'pot'),
                          c('water', 'pot'),
                          c('water', 'pot')),
            data = soya)

}
\seealso{
\code{mc_mult_multcomp}.
}
\author{
Lineu Alberto Cavazani de Freitas,
\email{lineuacf@gmail.com}
}
