% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/con_compIndex_holland.R
\name{con_compindex_holland}
\alias{con_compindex_holland}
\title{Compatibility Index according to Wiggins & Moody (1981)}
\usage{
con_compindex_holland(a, b)
}
\arguments{
\item{a}{a character vector with person Holland codes.}

\item{b}{a character vector with environment Holland codes.}
}
\value{
a numeric with value for congruence.
}
\description{
The function computes the three-letter \emph{Compatibility} index according to Wiggins & Moody (1981).
}
\details{
The function finds the congruence according to Wiggins & Moody (1981) between the three-letter Holland codes given in argument a, which is the person code, and argument b, which is the environment code. The Index as defined by Wiggins & Moody (1981) targets (only) three letters from the Holland code. The degree of congruence is output, according to its definition by Wiggins & Moody (1981), as a reciprocal value of a distance. This means, for example, that a value of '8' is the result for a perfect fit of two three-letter codes !
}
\examples{
con_compindex_holland(a="RIA",b="SEC") # max. difference 
con_compindex_holland(a="RIA",b="RIA") # max. similarity
}
\references{
Holland, J.L. 1963. A theory of vocational choice. I. Vocational images and choice. \emph{Vocational Guidance Quarterly, 11}(4), 232–239.

Wiggins, J. D. & Moody, A. (1981). A field-based comparison of four career-exploration approaches. \emph{Vocational Guidance Quarterly, 30}(1), 15–20. US: American Counseling Assn. https://doi.org/10.1002/j.2164-585X.1981.tb01071.x
}
\keyword{congruence}
