% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmi_smallfunctions.R
\name{hmi_pool}
\alias{hmi_pool}
\title{Averages the results of the imputation function \code{hmi}.}
\usage{
hmi_pool(mids, analysis_function)
}
\arguments{
\item{mids}{A \code{mids} (multiply imputed data set) object.
Either from the \code{hmi} imputation function or \code{mice}.}

\item{analysis_function}{A user generated function that gets a completed data set,
runs the model and returns all model parameters
he or she is interested in in a vector. See examples below.}
}
\value{
A vector with all averaged results.
}
\description{
This function applies the analysis the user wants to run on every imputed dataset.
The results from every dataset are pooled by simply averaging. So the user has to make sure that
averaging the analysis produces results is meaningful. Currently variance estimates for the averaged
results are not implemented.
}
\examples{
\dontrun{
 data(Gcsemv, package = "hmi")

 model_formula <- written ~ 1 + gender + coursework + (1 + gender|school)

 set.seed(123)
 dat_imputed <- hmi(data = Gcsemv, model_formula = model_formula, M = 2, maxit = 2)

 my_analysis <- function(complete_data){
  # In this list, you can write all the parameters you are interested in.
  # Those will be averaged.
  # So make sure that averaging makes sense and that you only put in single numeric values.
  parameters_of_interest <- list()

  # ---- write in the following lines, what you are interetest in to do with your complete_data
  # the following lines are an example where the analyst is interested in the fixed intercept
  # and fixed slope and the random intercepts variance,
  # the random slopes variance and their covariance
  my_model <- lmer(model_formula, data = complete_data)

  parameters_of_interest[[1]] <- fixef(my_model)
  parameters_of_interest[[2]] <- lme4::VarCorr(my_model)[[1]][,]
  ret <- unlist(parameters_of_interest)# This line is essential if the elements of interest
  #should be labeled in the following line.
  names(ret) <-
    c("beta_intercept", "beta_gender", "beta_coursework", "sigma0", "sigma01", "sigma10", "sigma1")

  return(ret)
}
hmi_pool(mids = dat_imputed, analysis_function = my_analysis)
#if you are interested in fixed effects only, consider pool from mice:
pool(with(data = dat_imputed, expr = lmer(written ~ 1 + gender + coursework + (1 + gender|school))))
}
}
