\name{datagen}
\alias{datagen}

\title{ Data generator
}
\description{
The data generator creates random samples from conditional Gaussian distribution with different
graph structures
}

\usage{
datagen(parlist,n)
}

\arguments{
  \item{parlist}{
        The parameter list generated by \code{pargen}
}
  \item{n}{
        The number of observations (sample size)
}
}
\details{
We use the exact probability rather than \code{MCMC} methods to generate the binary variables.
We generate the probability distribution of \code{Z} as well as the canonical parameters.
The memory requirements for the
distribution of \code{Z} make it difficult to generate a large number of binary variables in simulations.
However, this is not a problem for real data where the variables are already observed.
}
\value{
The function returns a data list:

\item{z}{ Value of binary variable}
\item{y}{ Value of continous variable}
\item{Prob}{ The probability distribution of discrete variables}
\item{cparlist}{The canonical parameter}
}
\references{
Jie Cheng, Tianxi Li, Elizaveta Levina, and Ji Zhu.(2017)
    \emph{High-dimensional Mixed Graphical Models. Journal of Computational and Graphical Statistics 26.2: 367-378},
    \url{https://arxiv.org/pdf/1304.2810.pdf}
}

\author{
  Mingyu Qi, Tianxi Li
}

\seealso{
\code{\link{pargen}}
}
\examples{
#set parameters
n = 100
p = 20
q = 10
a = 1
b = 2
c = 1
adj = matrix(0, p+q, p+q)
adj[10:16, 10:16] = 1
adj[1:5, 1:5] = 1
adj[25:30, 25:30] = 1
adj = adj-diag(diag(adj))
parlist = pargen(adj, p, q, a, b, c)

#generate data
mydata = datagen(parlist, n)

}
