% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlations.R
\name{gamma_exp}
\alias{gamma_exp}
\title{Gamma-exponential correlation function}
\usage{
gamma_exp(x, xp, hp)
}
\arguments{
\item{x}{A data.frame of rows corresponding to position vectors}

\item{xp}{A data.frame of rows corresponding to position vectors}

\item{hp}{The hyperparameters theta (correlation length) and gamma (exponent), as a named list}
}
\value{
The gamma-exponential correlation between x and xp.
}
\description{
For points \code{x}, \code{xp}, and a pair of hyperparameters \code{gamma} and \code{theta},
gives the gamma-exponential correlation between the two points.
}
\details{
The gamma-exponential correlation function, for d = |x-x'|, is given by
\eqn{\exp(-(d/\theta)^\gamma)}. Gamma must be between 0 (exclusive) and 2 (inclusive).
}
\examples{
gamma_exp(data.frame(a=1), data.frame(a=2), list(gamma = 1.5, theta = 0.1))
#> 1.846727e-14
gamma_exp(data.frame(a=1,b=2,c=-1),data.frame(a=1.5,b=2.9,c=-0.7), list(gamma = 1.3, theta = 0.2))
#> 0.0001399953
}
\references{
Rasmussen & Williams (2005) <ISBN: 9780262182539>
}
