% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genericevalhrz.R
\name{plot.hrzeval}
\alias{plot.hrzeval}
\title{Visualize the evaluation of a high-risk zone.}
\usage{
\method{plot}{hrzeval}(
  x,
  ...,
  hrz = NULL,
  obspp = NULL,
  plothrz = FALSE,
  plotobs = FALSE,
  windowcol = "white",
  insidecol = "blue",
  outsidecol = "red",
  insidepch = 20,
  outsidepch = 19,
  zonecol = "grey",
  obscol = "black",
  obspch = 1
)
}
\arguments{
\item{x}{evaluation of a high-risk zone (object of class "\code{hrzeval}")}

\item{...}{extra arguments passed to the generic \code{\link[graphics]{plot}} function.}

\item{hrz}{(optional) high-risk zone (object of class "\code{highriskzone}")}

\item{obspp}{(optional) observed point pattern}

\item{plothrz}{logical flag; should the high-risk zone be plotted?}

\item{plotobs}{logical flag; should the observed point pattern be plotted?}

\item{windowcol}{the color used to plot the observation window}

\item{insidecol}{the color used to plot the unobserved events inside the high-risk zone}

\item{outsidecol}{the color used to plot the unobserved events outside the high-risk zone}

\item{insidepch}{plotting 'character' of the unobserved events inside the high-risk zone,
i.e., symbol to use. This can either be a single character or an integer code for one of 
a set of graphics symbols. The full set of S symbols is available with pch=0:18, see 
\code{\link[graphics]{points}}.}

\item{outsidepch}{plotting 'character' of the unobserved events outside the high-risk zone}

\item{zonecol}{the color used to plot the high-risk zone}

\item{obscol}{the color used to plot the observed events}

\item{obspch}{plotting 'character' of the observed events}
}
\description{
Plot a visualization of the evaluation of a high-risk zone. At least the observation window and the unobserved events 
inside and outside the high-risk zone are plotted.
}
\details{
This is the plot method for the class \code{hrzeval}.
}
\seealso{
\code{\link[graphics]{plot}}, \code{\link{eval_hrz}}, \code{\link{plot.highriskzone}}
}
