% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_handling.R
\name{mergeQuotesSameTimestamp}
\alias{mergeQuotesSameTimestamp}
\title{Merge multiple quote entries with the same time stamp}
\usage{
mergeQuotesSameTimestamp(qData, selection = "median")
}
\arguments{
\item{qData}{an xts object or data.table containing the time series data, with 
at least two columns named "BID" and "OFR" indicating the bid and ask price 
and two columns "BIDSIZ", "OFRSIZ" indicating the number of round lots available at these 
prices. For data.table an additional column "DT" is necessary that stores the date/time information.}

\item{selection}{indicates how the bid and ask price for a certain time stamp
should be calculated in case of multiple observation for a certain time
stamp. By default, selection = "median", and the median price is taken. Alternatively:
\itemize{
\item selection = "max.volume": use the (bid/ask) price of the entry with
largest (bid/ask) volume.
\item selection = "weighted.average": take the weighted average of all bid (ask) prices,
weighted by "BIDSIZ" ("OFRSIZ").
}}
}
\value{
xts or data.table object depending on input
}
\description{
Function replaces multiple quote entries that have the same time stamp 
by a single one and returns an xts object with unique time stamps only.
}
\author{
Jonathan Cornelissen and Kris Boudt
}
\keyword{cleaning}
