% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{estimate_sample_moments}
\alias{estimate_sample_moments}
\title{Estimate first four moment parameters of multivariate observations}
\usage{
estimate_sample_moments(X, adjust_magnitude = FALSE)
}
\arguments{
\item{X}{Data matrix.}

\item{adjust_magnitude}{Boolean indicating whether to adjust the order of magnitude of parameters.
Note: this is specially designed for the function \code{\link{design_MVSKtilting_portfolio_via_sample_moments}()}.}
}
\value{
A list containing the following elements:
\item{\code{mu}}{Mean vector.}
\item{\code{Sgm}}{Covariance matrix.}
\item{\code{Phi_mat}}{Co-skewness matrix.}
\item{\code{Psi_mat}}{Co-kurtosis matrix.}
\item{\code{Phi}}{Co-skewness matrix in vector form (collecting only the unique elements).}
\item{\code{Psi}}{Co-kurtosis matrix in vector form (collecting only the unique elements).}
\item{\code{Phi_shred}}{Partition on \code{Phi} (see reference).}
\item{\code{Psi_shred}}{Partition on \code{Psi} (see reference).}
}
\description{
Estimate first four moments of multivariate observations, namely,
mean vector, covariance matrix, coskewness matrix, and cokurtosis matrix.
}
\examples{

library(highOrderPortfolios)
data(X50)

X_moments <- estimate_sample_moments(X50[, 1:10])


}
\references{
R. Zhou and D. P. Palomar, "Solving High-Order Portfolios via Successive Convex Approximation Algorithms," 
in \emph{IEEE Transactions on Signal Processing}, vol. 69, pp. 892-904, 2021.
<doi:10.1109/TSP.2021.3051369>.
}
\author{
Rui Zhou and Daniel P. Palomar
}
