% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plt_ttl.R
\name{plt_ttl}
\alias{plt_ttl}
\title{plt_ttl}
\usage{
plt_ttl(ttl, axs = "x", rotate_title = TRUE)
}
\arguments{
\item{ttl}{The name of the upper group.}

\item{axs}{The axis on which the name will appear (defaults to "x"). If `x`, the text will be
written at the top-centre of the plot. If `y`, the text will be written at the middle-right of the
plot.}

\item{rotate_title}{Whether the title should be rotate to be perpendicular to the axis (defaults
to TRUE). If TRUE, the title text on the x and y axes will be printed horizontally and vertically
respectively, with the reverse orientation if set to FALSE.}
}
\value{
A ggplot object containing the title of a given upper group, for use in the hhm function.
}
\description{
Creates plot containing the name of a given upper group. Used in combination with the
patchwork package to plot the names of the upper groups within the hhm function.
}
\examples{
plt_ttl("Group 1", axs = "y")
plt_ttl("Group 2")
plt_ttl("Group 1", axs = "y",rotate_title = FALSE)
plt_ttl("Group 2"           ,rotate_title = FALSE)

}
