% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexify_index.R
\name{hexify_cell_to_index}
\alias{hexify_cell_to_index}
\title{Convert cell coordinates to index string}
\usage{
hexify_cell_to_index(
  face,
  i,
  j,
  resolution,
  aperture = 3L,
  index_type = c("auto", "z3", "z7", "zorder")
)
}
\arguments{
\item{face}{Face/quad number (0-19)}

\item{i}{I coordinate}

\item{j}{J coordinate}

\item{resolution}{Resolution level}

\item{aperture}{Aperture (3, 4, or 7)}

\item{index_type}{Index encoding: "auto" (default), "z3", "z7", or "zorder"}
}
\value{
Index string (e.g., "051223")
}
\description{
Converts DGGRID cell coordinates (face, i, j) to a hierarchical index string.
The index type is automatically selected based on aperture unless specified.
}
\details{
Default index types by aperture:
\itemize{
\item Aperture 3: Z3 (optimized digit selection)
\item Aperture 4: Z-order (Morton curve)
\item Aperture 7: Z7 (hierarchical with Class III handling)
}
}
\examples{
idx <- hexify_cell_to_index(5, 10, 15, resolution = 3, aperture = 3)
}
\seealso{
Other hierarchical index: 
\code{\link{hexify_compare_indices}()},
\code{\link{hexify_default_index_type}()},
\code{\link{hexify_get_children}()},
\code{\link{hexify_get_parent}()},
\code{\link{hexify_get_resolution}()},
\code{\link{hexify_index_to_cell}()},
\code{\link{hexify_index_to_lonlat}()},
\code{\link{hexify_is_valid_index_type}()},
\code{\link{hexify_lonlat_to_index}()},
\code{\link{hexify_z7_canonical}()}
}
\concept{hierarchical index}
\keyword{internal}
