% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causal_performance.R
\name{causal_performance}
\alias{causal_performance}
\title{Performance map profile}
\usage{
causal_performance(FUN = mean, units = c("mins", "secs", "hours",
  "days", "weeks", "months", "quarters", "semesters", "years"),
  color_scale = "Reds", color_edges = "red4", ...)
}
\arguments{
\item{FUN}{A summary function to be called on the process time of a specific activity, e.g. mean, median, min, max}

\item{units}{The time unit in which processing time should be presented (mins, hours, days, weeks, months, quarters, semesters, years. A month is defined as 30 days. A quarter is 13 weeks. A semester is 26 weeks and a year is 365 days}

\item{color_scale}{Name of color scale to be used for nodes. Defaults to Reds. See \code{Rcolorbrewer::brewer.pal.info()} for all options.}

\item{color_edges}{The color used for edges. Defaults to red4.}

\item{...}{Additional arguments forwarded to FUN}
}
\description{
Function to create a performance profile for a causal map.
}
\examples{
causal_net(L_heur_1,
           type = causal_performance())

}
