% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_def.R
\name{define_tparams}
\alias{define_tparams}
\alias{eval_tparams}
\title{Define and evaluate transformed parameter expressions}
\usage{
define_tparams(expr, times = NULL, ...)

eval_tparams(x, input_data, rng_params)
}
\arguments{
\item{expr}{Expressions used to transform parameters. As with \code{\link[=define_rng]{define_rng()}},
\link[base:Paren]{braces} should be used so that the result
of the last expression within the braces is evaluated. The expression
must return a named list with the following possible elements:
\itemize{
\item \emph{tpmatrix}: The transition probability matrix used to simulate transition
probabilities in the economic model. Typically the output of
\code{\link[=tpmatrix]{tpmatrix()}}.
\item \emph{utility}: The utility values to attach to states and used to simulate
quality-adjusted life-years in the economic model. Either a vector (in
which case utility is the same in each health state) or a
\code{data.table}/\code{data.frame}/\code{matrix} with a column for each (non-death)
health state.
\item \emph{costs}:  A named list of costs for each category used to simulate
costs in the economic model. Each element of the
list must be in the same format as \code{utility}.
}}

\item{times}{Distinct times denoting the stopping time of time intervals.}

\item{...}{Additional arguments to pass to the environment used to evaluate
\code{expr}.}

\item{x}{An object of class \code{tparams_def}.}

\item{input_data}{An object of class \link[=expand.hesim_data]{expanded_hesim_data} (as
in \code{\link[=eval_model]{eval_model()}}) expanded by the distinct times in \code{times}.}

\item{rng_params}{Random samples of the parameters returned by \code{\link[=eval_rng]{eval_rng()}}.}
}
\value{
\code{\link[=define_tparams]{define_tparams()}} returns an object of class \code{tparams_def},
which is a list containing the unevaluated "transformation" expressions
passed  to \code{expr}, \code{times}, and any additional arguments passed to
\code{...} . \code{\link[=eval_tparams]{eval_tparams()}} evaluates the \code{tparams_def} object
and should return a list of transformed parameter objects.
}
\description{
Transformed parameter expressions are used to transform the parameter
values sampled with \code{\link[=eval_rng]{eval_rng()}} as a function of input data
(treatment strategies and patients) and time
intervals. These functions are used when evaluating an object of class
\code{model_def} defined using \code{\link[=define_model]{define_model()}}. The transformed parameters
are ultimately converted into \link{tparams} objects and used to simulate outcomes with an
economic model.
}
\details{
\code{define_tparams()} is evaluated when creating economic models as a
function of \code{model_def} objects defined with \code{\link[=define_model]{define_model()}}. Operations
are "vectorized" in the sense that they are performed for each unique combination
of \code{input_data} and \code{params}. \code{expr} is evaluated in an environment including
each variable from \code{input_data}, all elements of \code{rng_params}, and a variable
\code{time} containing the values from \code{times}. The \code{time} variable can be used
to create models where parameters vary as a function of time.
\code{eval_tparams()} is not exported and is only meant for use within \code{\link[=eval_model]{eval_model()}}.
}
\seealso{
\code{\link[=define_model]{define_model()}}, \code{\link[=define_rng]{define_rng()}}
}
