% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ellipse.axes.R
\name{ellipse.axes}
\alias{ellipse.axes}
\title{Draw Axes of a 2D Covariance Ellipse}
\usage{
ellipse.axes(
  x,
  centre = c(0, 0),
  center = center,
  scale = c(1, 1),
  which = 1:2,
  level = 0.95,
  radius = sqrt(qchisq(level, 2)),
  labels = TRUE,
  label.ends = c(2, 4),
  label.pos = c(2, 4, 1, 3),
  ...
)
}
\arguments{
\item{x}{A square positive definite matrix at least 2x2 in size.  It will be
treated as the correlation or covariance of a multivariate normal
distribution.}

\item{centre, center}{The center of the ellipse}

\item{scale}{If x is a correlation matrix, then the standard deviations of
each parameter can be given in the scale parameter.  This defaults to
\code{c(1, 1)}, so no rescaling will be done.}

\item{which}{An integer vector to select which variables from the object \code{x} will be
plotted.  The default is the first 2.}

\item{level}{The coverage level of a simultaneous region of the ellipse.  The
default is 0.95, for a 95\% region.  This is used to control the size of the
ellipse.}

\item{radius}{The size of the ellipsoid may also be controlled by specifying the
value of a t-statistic on its boundary. This defaults to the square root of a chi-square statistic
for a given \code{level} on 2 degrees of freedom, however in a small sample of \code{n} observations,
a more accurate value is \code{sqrt(2 * qf(level, 2, n - 1 ))}.}

\item{labels}{Either a logical value, a character string, or a character
vector of length 2.  If \code{TRUE}, the default, the axes are labeled "PC1",
"PC2".  If a single character string, the digits 1, and 2 are pasted on
the end.}

\item{label.ends}{A vector of indices in the range \code{1:4} indicating which ends of the axes
should be labeled, corresponding to a selection of rows of the 4 x 2 matrix
of axes end points. Values \code{1:2} represent the minimum and maximum of the first dimension respectively.
Values \code{3:4} represent the minimum and maximum of the second dimension.
Default: \code{c(2, 4)}.}

\item{label.pos}{Positions of text labels relative to the ends of the axes used in \code{\link[graphics]{text}} for
the four possible \code{label.ends}. 1, 2, 3, 4 represent below, to the left, above and to the right.
The default, \code{c(2, 4, 1, 3)}, positions the labels outside the axes.}

\item{\dots}{Other arguments passed to \code{\link[graphics]{lines}} and \code{\link[graphics]{text}}.}
}
\value{
Invisibly returns a 4 x 2 matrix containing the end points of the axes in pairs (min, max) by rows.
}
\description{
A function to draw the principal axes of a 2D ellipse from a correlation,
covariance or sums of squares and cross products matrix in an existing plot.
}
\examples{
data(iris)
cov <- cov(iris[,1:2])
mu <- colMeans(iris[,1:2])

radius <- sqrt(qchisq(0.68, 2))
plot(iris[,1:2], asp=1)
car::ellipse(mu, cov, radius = radius)
res <- ellipse.axes(cov, center=mu, level = 0.68,
            labels = TRUE)
res
}
\seealso{
\code{\link[graphics]{lines}}, \code{\link[graphics]{text}}
}
\author{
Michael Friendly
}
