% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binarize_fisheye.R
\name{binarize_fisheye}
\alias{binarize_fisheye}
\title{Compute the threshold of a single-channel fisheye image, and return a binary fisheye image of canopy (0) and gap (1) pixels}
\usage{
binarize_fisheye(
  img,
  method = "Otsu",
  zonal = FALSE,
  manual = NULL,
  display = FALSE,
  export = FALSE
)
}
\arguments{
\item{img}{Raster. Fisheye image imported by \code{\link[=import_fisheye]{import_fisheye()}} as a single-band raster using the \code{\link[raster:raster]{raster::raster()}} functionality.}

\item{method}{Character. The method used to threshold the image, using the \code{\link[autothresholdr:auto_thresh]{autothresholdr::auto_thresh()}} function. For details, see \url{https://imagej.net/plugins/auto-threshold}. Default = 'Otsu'.}

\item{zonal}{Logical. If is set to TRUE, it divides the images in four (N, W, S, E) regions and classify each region separately. Useful in case of uneven illumination condition in the image.}

\item{manual}{Numeric. It uses a manual thresholding instead of automatic one. If selected, it overrides automatic thresholding.}

\item{display}{Logical. If is set to TRUE, it plots the classified binary image. Default to FALSE.}

\item{export}{Logical. If is set to TRUE, it saves the binary fisheye image as tif file. Default to FALSE.}
}
\value{
A binary raster image
}
\description{
The function calculates a single threshold of a single-channel raster image using  the \code{\link[autothresholdr:auto_thresh]{autothresholdr::auto_thresh()}} functionality.
The single thresholding is also applied at sub-image level if zonal=TRUE.
The available methods are described at \url{https://imagej.net/plugins/auto-threshold}.
The thresholding value is then used to make a binary raster image of canopy (0) and gap (1) pixels.
}
\examples{
\donttest{
c.im<-system.file('extdata/circular_coolpix4500+FC-E8_chestnut.jpg',package='hemispheR')

c.im |>
import_fisheye(circ.mask=camera_fisheye('Coolpix4500+FC-E8')) |>
 binarize_fisheye(display=TRUE)

#zonal thresholding:
c.im |>
import_fisheye(circ.mask=camera_fisheye('Coolpix4500+FC-E8')) |>
 binarize_fisheye(zonal=TRUE,display=TRUE)

#manual thresholding:
c.im |>
import_fisheye(circ.mask=camera_fisheye('Coolpix4500+FC-E8')) |>
binarize_fisheye(manual=55,display=TRUE)
}
}
\seealso{
\url{https://imagej.net/plugins/auto-threshold}
}
