% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeans-funcs.R
\name{kmeans_scree_plt}
\alias{kmeans_scree_plt}
\title{K-Means Scree Plot}
\usage{
kmeans_scree_plt(.data)
}
\arguments{
\item{.data}{The data from the \code{\link[=kmeans_mapped_tbl]{kmeans_mapped_tbl()}} function}
}
\value{
A ggplot2 plot
}
\description{
Create a scree-plot from the \code{\link[=kmeans_mapped_tbl]{kmeans_mapped_tbl()}} function.
}
\details{
Outputs a scree-plot
}
\examples{
library(healthyR.data)
library(dplyr)
library(tidyquant)

data_tbl <- healthyR_data\%>\%
   filter(ip_op_flag == "I") \%>\%
   filter(payer_grouping != "Medicare B") \%>\%
   filter(payer_grouping != "?") \%>\%
   select(service_line, payer_grouping) \%>\%
   mutate(record = 1) \%>\%
   as_tibble()

ui_tbl <-  kmeans_user_item_tbl(data_tbl, service_line, payer_grouping)

kmm_tbl <- kmeans_mapped_tbl(ui_tbl)

kmeans_scree_plt(.data = kmm_tbl)

}
\seealso{
\url{https://en.wikipedia.org/wiki/Scree_plot}
}
\author{
Steven P. Sanderson II, MPH
}
