% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto-kmeans.R
\name{hai_kmeans_automl}
\alias{hai_kmeans_automl}
\title{Automatic K-Means H2O}
\usage{
hai_kmeans_automl(
  .data,
  .split_ratio = 0.8,
  .seed = 1234,
  .centers = 10,
  .standardize = TRUE,
  .print_model_summary = TRUE,
  .predictors,
  .categorical_encoding = "auto",
  .initialization_mode = "Furthest",
  .max_iterations = 100
)
}
\arguments{
\item{.data}{The data that is to be passed for clustering.}

\item{.split_ratio}{The ratio for training and testing splits.}

\item{.seed}{The default is 1234, but can be set to any integer.}

\item{.centers}{The default is 1. Specify the number of clusters (groups of data)
in a data set.}

\item{.standardize}{The default is set to TRUE. When TRUE all numeric columns
will be set to zero mean and unit variance.}

\item{.print_model_summary}{This is a boolean and controls if the model summary
is printed to the console. The default is TRUE.}

\item{.predictors}{This must be in the form of c("column_1", "column_2", ... "column_n")}

\item{.categorical_encoding}{Can be one of the following:
\itemize{
\item "auto"
\item "enum"
\item "one_hot_explicit"
\item "binary"
\item "eigen"
\item "label_encoder"
\item "sort_by_response"
\item "enum_limited"
}}

\item{.initialization_mode}{This can be one of the following:
\itemize{
\item "Random"
\item "Furthest (default)
\item "PlusPlus"
}}

\item{.max_iterations}{The default is 100. This specifies the number of training
iterations}
}
\value{
A list object
}
\description{
This is a wrapper around the \code{\link[h2o:h2o.kmeans]{h2o::h2o.kmeans()}} function that will return a list
object with a lot of useful and easy to use tidy style information.
}
\examples{
\dontrun{
h2o.init()
output <- hai_kmeans_automl(
  .data = iris,
  .predictors = c("Sepal.Width", "Sepal.Length", "Petal.Width", "Petal.Length"),
  .standardize = FALSE
)
h2o.shutdown()
}

}
\seealso{
Other Kmeans: 
\code{\link{hai_kmeans_automl_predict}()},
\code{\link{hai_kmeans_mapped_tbl}()},
\code{\link{hai_kmeans_obj}()},
\code{\link{hai_kmeans_scree_data_tbl}()},
\code{\link{hai_kmeans_scree_plt}()},
\code{\link{hai_kmeans_tidy_tbl}()},
\code{\link{hai_kmeans_user_item_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Kmeans}
