% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmean-funcs.R
\name{hai_kmeans_scree_plt}
\alias{hai_kmeans_scree_plt}
\alias{kmeans_scree_plt}
\alias{hai_kmeans_scree_plot}
\title{K-Means Scree Plot}
\usage{
hai_kmeans_scree_plt(.data)

kmeans_scree_plt(.data)

hai_kmeans_scree_plot(.data)
}
\arguments{
\item{.data}{The data from the \code{\link[=hai_kmeans_mapped_tbl]{hai_kmeans_mapped_tbl()}} function}
}
\value{
A ggplot2 plot
}
\description{
Create a scree-plot from the \code{\link[=hai_kmeans_mapped_tbl]{hai_kmeans_mapped_tbl()}} function.
}
\details{
Outputs a scree-plot
}
\examples{
library(healthyR.data)
library(dplyr)

data_tbl <- healthyR_data \%>\%
  filter(ip_op_flag == "I") \%>\%
  filter(payer_grouping != "Medicare B") \%>\%
  filter(payer_grouping != "?") \%>\%
  select(service_line, payer_grouping) \%>\%
  mutate(record = 1) \%>\%
  as_tibble()

ui_tbl <- hai_kmeans_user_item_tbl(
  .data = data_tbl,
  .row_input = service_line,
  .col_input = payer_grouping,
  .record_input = record
)

kmm_tbl <- hai_kmeans_mapped_tbl(ui_tbl)

hai_kmeans_scree_plt(.data = kmm_tbl)

}
\seealso{
\url{https://en.wikipedia.org/wiki/Scree_plot}

Other Kmeans: 
\code{\link{hai_kmeans_automl_predict}()},
\code{\link{hai_kmeans_automl}()},
\code{\link{hai_kmeans_mapped_tbl}()},
\code{\link{hai_kmeans_obj}()},
\code{\link{hai_kmeans_scree_data_tbl}()},
\code{\link{hai_kmeans_tidy_tbl}()},
\code{\link{hai_kmeans_user_item_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Kmeans}
