% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{selectData}
\alias{selectData}
\title{Pull data into R via an ODBC connection}
\usage{
selectData(connectionString, query, randomize = FALSE)
}
\arguments{
\item{connectionString}{A string specifying the driver, server, database,
and whether Windows Authentication will be used.}

\item{query}{The SQL query (in ticks or quotes)}

\item{randomize}{Boolean that dictates whether returned rows are randomized}
}
\value{
df A data frame containing the selected rows
}
\description{
Select data from an ODBC database and return the results as
a data frame.
}
\examples{

\donttest{
#### This example is specific to Windows and is not tested. 
connectionString <- '
  driver={SQL Server};
  server=localhost;
  database=SAM;
  trustedConnection=true
  '

query <- '
  SELECT
    A1CNBR
  FROM SAM.dbo.HCRDiabetesClinical
  '

df <- selectData(connectionString, query)
head(df)
}
}
\references{
\url{http://healthcare.ai}
}
\seealso{
\code{\link{healthcareai}}
}
