% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/hdnom.models.R
\name{hdcox.flasso}
\alias{hdcox.flasso}
\title{Fused lasso model selection for high-dimensional Cox models}
\usage{
hdcox.flasso(x, y, nfolds = 5L, seed = 1001, trace = FALSE)
}
\arguments{
\item{x}{Data matrix.}

\item{y}{Response matrix made by \code{\link[survival]{Surv}}.}

\item{nfolds}{Fold numbers of cross-validation.}

\item{seed}{A random seed for cross-validation fold division.}

\item{trace}{Output the cross-validation parameter tuning
progress or not. Default is \code{FALSE}.}
}
\description{
Automatic fused lasso model selection for high-dimensional
Cox models, evaluated by penalized partial-likelihood.
}
\note{
The cross-validation procedure used in this function is the
so-called approximated cross-validation provided by the \code{penalized}
package. Be careful dealing with the results since they might be more
optimistic than fully fitting the model. This cross-validation method
is more suitable for datasets with larger number of observations,
and a higher number of cross-validation folds.
}
\examples{
library("penalized")
library("survival")
library("rms")

# Load imputed SMART data; only use the first 120 samples
data("smart")
x = as.matrix(smart[, -c(1, 2)])[1:120, ]
time = smart$TEVENT[1:120]
event = smart$EVENT[1:120]
y = Surv(time, event)

# Fit Cox model by fused lasso penalization
flassofit = hdcox.flasso(x, y, nfolds = 3, seed = 11)

# Prepare data for hdnom.nomogram
x.df = as.data.frame(x)
dd = datadist(x.df)
options(datadist = "dd")

# Generate hdnom.nomogram objects and plot nomogram
nom = hdnom.nomogram(flassofit$flasso_model, model.type = 'flasso',
                     x, time, event, x.df,
                     lambda = flassofit$flasso_best_lambda, pred.at = 365 * 2,
                     funlabel = "2-Year Overall Survival Probability")

plot(nom)
}

