% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmus.R
\name{gmus}
\alias{gmus}
\title{Generalized Matrix Uncertainty Selector}
\usage{
gmus(W, y, lambda = NULL, delta = NULL, family = "gaussian",
  weights = NULL)
}
\arguments{
\item{W}{Design matrix, measured with error. Must be a numeric matrix.}

\item{y}{Vector of responses.}

\item{lambda}{Regularization parameter.}

\item{delta}{Additional regularization parameter, bounding the measurement
error.}

\item{family}{"gaussian" for linear regression, "binomial" for logistic
regression or "poisson" for Poisson regression. Defaults go "gaussian".}

\item{weights}{A vector of weights for each row of \code{X}.}
}
\value{
An object of class "gmus".
}
\description{
Generalized Matrix Uncertainty Selector
}
\examples{
# Example with linear regression
set.seed(1)
n <- 100 # Number of samples
p <- 50 # Number of covariates
# True (latent) variables
X <- matrix(rnorm(n * p), nrow = n)
# Measurement matrix (this is the one we observe)
W <- X + matrix(rnorm(n*p, sd = 1), nrow = n, ncol = p)
# Coefficient vector
beta <- c(seq(from = 0.1, to = 1, length.out = 5), rep(0, p-5))
# Response
y <- X \%*\% beta + rnorm(n, sd = 1)
# Run the MU Selector
fit1 <- gmus(W, y)
# Draw an elbow plot to select delta
plot(fit1)
coef(fit1)

# Now, according to the "elbow rule", choose
# the final delta where the curve has an "elbow".
# In this case, the elbow is at about delta = 0.08,
# so we use this to compute the final estimate:
fit2 <- gmus(W, y, delta = 0.08)
# Plot the coefficients
plot(fit2)
coef(fit2)
coef(fit2, all = TRUE)

}
\references{
\insertRef{rosenbaum2010}{hdme}

  \insertRef{sorensen2018}{hdme}
}
