// (c) The HDF Group
#ifndef H5Opublic_H
#define H5Opublic_H
#include "H5public.h"
#include "H5Ipublic.h"
#define H5O_COPY_SHALLOW_HIERARCHY_FLAG     (0x0001u)
#define H5O_COPY_EXPAND_SOFT_LINK_FLAG      (0x0002u)
#define H5O_COPY_EXPAND_EXT_LINK_FLAG       (0x0004u)
#define H5O_COPY_EXPAND_REFERENCE_FLAG      (0x0008u)
#define H5O_COPY_WITHOUT_ATTR_FLAG          (0x0010u)
#define H5O_COPY_PRESERVE_NULL_FLAG         (0x0020u)
#define H5O_COPY_MERGE_COMMITTED_DTYPE_FLAG (0x0040u)
#define H5O_COPY_ALL                        (0x007Fu)
#define H5O_SHMESG_NONE_FLAG    0x0000
#define H5O_SHMESG_SDSPACE_FLAG ((unsigned)1 << 0x0001)
#define H5O_SHMESG_DTYPE_FLAG   ((unsigned)1 << 0x0003)
#define H5O_SHMESG_FILL_FLAG    ((unsigned)1 << 0x0005)
#define H5O_SHMESG_PLINE_FLAG   ((unsigned)1 << 0x000b)
#define H5O_SHMESG_ATTR_FLAG    ((unsigned)1 << 0x000c)
#define H5O_SHMESG_ALL_FLAG                                                                                  \
    (H5O_SHMESG_SDSPACE_FLAG | H5O_SHMESG_DTYPE_FLAG | H5O_SHMESG_FILL_FLAG | H5O_SHMESG_PLINE_FLAG |        \
     H5O_SHMESG_ATTR_FLAG)
#define H5O_HDR_CHUNK0_SIZE             0x03
#define H5O_HDR_ATTR_CRT_ORDER_TRACKED  0x04
#define H5O_HDR_ATTR_CRT_ORDER_INDEXED  0x08
#define H5O_HDR_ATTR_STORE_PHASE_CHANGE 0x10
#define H5O_HDR_STORE_TIMES             0x20
#define H5O_HDR_ALL_FLAGS                                                                                    \
    (H5O_HDR_CHUNK0_SIZE | H5O_HDR_ATTR_CRT_ORDER_TRACKED | H5O_HDR_ATTR_CRT_ORDER_INDEXED |                 \
     H5O_HDR_ATTR_STORE_PHASE_CHANGE | H5O_HDR_STORE_TIMES)
#define H5O_SHMESG_MAX_NINDEXES  8
#define H5O_SHMESG_MAX_LIST_SIZE 5000
#define H5O_INFO_BASIC     0x0001u
#define H5O_INFO_TIME      0x0002u
#define H5O_INFO_NUM_ATTRS 0x0004u
#define H5O_INFO_ALL       (H5O_INFO_BASIC | H5O_INFO_TIME | H5O_INFO_NUM_ATTRS)
//! <!-- [H5O_native_info_fields_snip] -->
#define H5O_NATIVE_INFO_HDR       0x0008u
#define H5O_NATIVE_INFO_META_SIZE 0x0010u
#define H5O_NATIVE_INFO_ALL       (H5O_NATIVE_INFO_HDR | H5O_NATIVE_INFO_META_SIZE)
//! <!-- [H5O_native_info_fields_snip] -->
#define H5O_IS_TOKEN_UNDEF(token) (!memcmp(&(token), &(H5O_TOKEN_UNDEF), sizeof(H5O_token_t)))
//! <!-- [H5O_type_t_snip] -->
typedef enum H5O_type_t {
    H5O_TYPE_UNKNOWN = -1,
    H5O_TYPE_GROUP,
    H5O_TYPE_DATASET,
    H5O_TYPE_NAMED_DATATYPE,
    H5O_TYPE_MAP,
    H5O_TYPE_NTYPES
} H5O_type_t;
//! <!-- [H5O_type_t_snip] -->
//! <!-- [H5O_hdr_info_t_snip] -->
typedef struct H5O_hdr_info_t {
    unsigned version;
    unsigned nmesgs;
    unsigned nchunks;
    unsigned flags;
    struct {
        hsize_t total;
        hsize_t meta;
        hsize_t mesg;
        hsize_t free;
    } space;
    struct {
        uint64_t present;
        uint64_t shared;
    } mesg;
} H5O_hdr_info_t;
//! <!-- [H5O_hdr_info_t_snip] -->
//! <!-- [H5O_info2_t_snip] -->
typedef struct H5O_info2_t {
    unsigned long
        fileno;
    H5O_token_t token;
    H5O_type_t  type;
    unsigned    rc;
    time_t      atime;
    time_t      mtime;
    time_t      ctime;
    time_t      btime;
    hsize_t     num_attrs;
} H5O_info2_t;
//! <!-- [H5O_info2_t_snip] -->
//! <!-- [H5O_native_info_t_snip] -->
typedef struct H5O_native_info_t {
    H5O_hdr_info_t hdr;
    struct {
        H5_ih_info_t obj;
        H5_ih_info_t attr;
    } meta_size;
} H5O_native_info_t;
//! <!-- [H5O_native_info_t_snip] -->
typedef uint32_t H5O_msg_crt_idx_t;
//! <!-- [H5O_iterate2_t_snip] -->
typedef herr_t (*H5O_iterate2_t)(hid_t obj, const char *name, const H5O_info2_t *info, void *op_data);
//! <!-- [H5O_iterate2_t_snip] -->
//! <!-- [H5O_mcdt_search_ret_t_snip] -->
typedef enum H5O_mcdt_search_ret_t {
    H5O_MCDT_SEARCH_ERROR = -1,
    H5O_MCDT_SEARCH_CONT,
    H5O_MCDT_SEARCH_STOP
} H5O_mcdt_search_ret_t;
//! <!-- [H5O_mcdt_search_ret_t_snip] -->
//! <!-- [H5O_mcdt_search_cb_t_snip] -->
typedef H5O_mcdt_search_ret_t (*H5O_mcdt_search_cb_t)(void *op_data);
//! <!-- [H5O_mcdt_search_cb_t_snip] -->
#ifdef __cplusplus
extern "C" {
#endif
H5_DLL hid_t H5Oopen(hid_t loc_id, const char *name, hid_t lapl_id);
#ifndef H5_DOXYGEN
H5_DLL hid_t H5Oopen_async(const char *app_file, const char *app_func, unsigned app_line, hid_t loc_id,
                           const char *name, hid_t lapl_id, hid_t es_id);
#else
H5_DLL hid_t H5Oopen_async(hid_t loc_id, const char *name, hid_t lapl_id, hid_t es_id);
#endif
H5_DLL hid_t H5Oopen_by_token(hid_t loc_id, H5O_token_t token);
H5_DLL hid_t H5Oopen_by_idx(hid_t loc_id, const char *group_name, H5_index_t idx_type, H5_iter_order_t order,
                            hsize_t n, hid_t lapl_id);
#ifndef H5_DOXYGEN
H5_DLL hid_t H5Oopen_by_idx_async(const char *app_file, const char *app_func, unsigned app_line, hid_t loc_id,
                                  const char *group_name, H5_index_t idx_type, H5_iter_order_t order,
                                  hsize_t n, hid_t lapl_id, hid_t es_id);
#else
H5_DLL hid_t H5Oopen_by_idx_async(hid_t loc_id, const char *group_name, H5_index_t idx_type,
                                  H5_iter_order_t order, hsize_t n, hid_t lapl_id, hid_t es_id);
#endif
H5_DLL htri_t H5Oexists_by_name(hid_t loc_id, const char *name, hid_t lapl_id);
H5_DLL herr_t H5Oget_info3(hid_t loc_id, H5O_info2_t *oinfo, unsigned fields);
H5_DLL herr_t H5Oget_info_by_name3(hid_t loc_id, const char *name, H5O_info2_t *oinfo, unsigned fields,
                                   hid_t lapl_id);
#ifndef H5_DOXYGEN
H5_DLL herr_t H5Oget_info_by_name_async(const char *app_file, const char *app_func, unsigned app_line,
                                        hid_t loc_id, const char *name, H5O_info2_t *oinfo,
                                        unsigned fields, hid_t lapl_id, hid_t es_id);
#else
H5_DLL herr_t H5Oget_info_by_name_async(hid_t loc_id, const char *name, H5O_info2_t *oinfo,
                                        unsigned fields, hid_t lapl_id, hid_t es_id);
#endif
H5_DLL herr_t H5Oget_info_by_idx3(hid_t loc_id, const char *group_name, H5_index_t idx_type,
                                  H5_iter_order_t order, hsize_t n, H5O_info2_t *oinfo, unsigned fields,
                                  hid_t lapl_id);
H5_DLL herr_t H5Oget_native_info(hid_t loc_id, H5O_native_info_t *oinfo, unsigned fields);
H5_DLL herr_t H5Oget_native_info_by_name(hid_t loc_id, const char *name, H5O_native_info_t *oinfo,
                                         unsigned fields, hid_t lapl_id);
H5_DLL herr_t H5Oget_native_info_by_idx(hid_t loc_id, const char *group_name, H5_index_t idx_type,
                                        H5_iter_order_t order, hsize_t n, H5O_native_info_t *oinfo,
                                        unsigned fields, hid_t lapl_id);
H5_DLL herr_t H5Olink(hid_t obj_id, hid_t new_loc_id, const char *new_name, hid_t lcpl_id, hid_t lapl_id);
H5_DLL herr_t H5Oincr_refcount(hid_t object_id);
H5_DLL herr_t H5Odecr_refcount(hid_t object_id);
H5_DLL herr_t H5Ocopy(hid_t src_loc_id, const char *src_name, hid_t dst_loc_id, const char *dst_name,
                      hid_t ocpypl_id, hid_t lcpl_id);
#ifndef H5_DOXYGEN
H5_DLL herr_t H5Ocopy_async(const char *app_file, const char *app_func, unsigned app_line, hid_t src_loc_id,
                            const char *src_name, hid_t dst_loc_id, const char *dst_name, hid_t ocpypl_id,
                            hid_t lcpl_id, hid_t es_id);
#else
H5_DLL herr_t H5Ocopy_async(hid_t src_loc_id, const char *src_name, hid_t dst_loc_id, const char *dst_name,
                            hid_t ocpypl_id, hid_t lcpl_id, hid_t es_id);
#endif
H5_DLL herr_t H5Oset_comment(hid_t obj_id, const char *comment);
H5_DLL herr_t H5Oset_comment_by_name(hid_t loc_id, const char *name, const char *comment, hid_t lapl_id);
H5_DLL ssize_t H5Oget_comment(hid_t obj_id, char *comment, size_t bufsize);
H5_DLL ssize_t H5Oget_comment_by_name(hid_t loc_id, const char *name, char *comment, size_t bufsize,
                                      hid_t lapl_id);
H5_DLL herr_t H5Ovisit3(hid_t obj_id, H5_index_t idx_type, H5_iter_order_t order, H5O_iterate2_t op,
                        void *op_data, unsigned fields);
H5_DLL herr_t H5Ovisit_by_name3(hid_t loc_id, const char *obj_name, H5_index_t idx_type,
                                H5_iter_order_t order, H5O_iterate2_t op, void *op_data, unsigned fields,
                                hid_t lapl_id);
H5_DLL herr_t H5Oclose(hid_t object_id);
#ifndef H5_DOXYGEN
H5_DLL herr_t H5Oclose_async(const char *app_file, const char *app_func, unsigned app_line, hid_t object_id,
                             hid_t es_id);
#else
H5_DLL herr_t H5Oclose_async(hid_t object_id, hid_t es_id);
#endif
H5_DLL herr_t H5Oflush(hid_t obj_id);
#ifndef H5_DOXYGEN
H5_DLL herr_t H5Oflush_async(const char *app_file, const char *app_func, unsigned app_line, hid_t obj_id,
                             hid_t es_id);
#else
H5_DLL herr_t H5Oflush_async(hid_t obj_id, hid_t es_id);
#endif
H5_DLL herr_t H5Orefresh(hid_t oid);
#ifndef H5_DOXYGEN
H5_DLL herr_t H5Orefresh_async(const char *app_file, const char *app_func, unsigned app_line, hid_t oid,
                               hid_t es_id);
#else
H5_DLL herr_t H5Orefresh_async(hid_t oid, hid_t es_id);
#endif
H5_DLL herr_t H5Odisable_mdc_flushes(hid_t object_id);
H5_DLL herr_t H5Oenable_mdc_flushes(hid_t object_id);
H5_DLL herr_t H5Oare_mdc_flushes_disabled(hid_t object_id, hbool_t *are_disabled);
H5_DLL herr_t H5Otoken_cmp(hid_t loc_id, const H5O_token_t *token1, const H5O_token_t *token2,
                           int *cmp_value);
H5_DLL herr_t H5Otoken_to_str(hid_t loc_id, const H5O_token_t *token, char **token_str);
H5_DLL herr_t H5Otoken_from_str(hid_t loc_id, const char *token_str, H5O_token_t *token);
/// \cond DEV
#ifndef H5O_MODULE
#define H5Oopen_async(...)             H5Oopen_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Oopen_by_idx_async(...)      H5Oopen_by_idx_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Oget_info_by_name_async(...) H5Oget_info_by_name_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Oclose_async(...)            H5Oclose_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Oflush_async(...)            H5Oflush_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Orefresh_async(...)          H5Orefresh_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Ocopy_async(...)             H5Ocopy_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Oopen_async_wrap             H5_NO_EXPAND(H5Oopen_async)
#define H5Oopen_by_idx_async_wrap      H5_NO_EXPAND(H5Oopen_by_idx_async)
#define H5Oget_info_by_name_async_wrap H5_NO_EXPAND(H5Oget_info_by_name_async)
#define H5Oclose_async_wrap            H5_NO_EXPAND(H5Oclose_async)
#define H5Oflush_async_wrap            H5_NO_EXPAND(H5Oflush_async)
#define H5Orefresh_async_wrap          H5_NO_EXPAND(H5Orefresh_async)
#define H5Ocopy_async_wrap             H5_NO_EXPAND(H5Ocopy_async)
#endif
/// \endcond
#define H5O_TOKEN_UNDEF (H5OPEN H5O_TOKEN_UNDEF_g)
H5_DLLVAR const H5O_token_t H5O_TOKEN_UNDEF_g;
#ifndef H5_NO_DEPRECATED_SYMBOLS
#define H5O_INFO_HDR       0x0008u
#define H5O_INFO_META_SIZE 0x0010u
#undef H5O_INFO_ALL
#define H5O_INFO_ALL (H5O_INFO_BASIC | H5O_INFO_TIME | H5O_INFO_NUM_ATTRS | H5O_INFO_HDR | H5O_INFO_META_SIZE)
//! <!-- [H5O_stat_t_snip] -->
typedef struct H5O_stat_t {
    hsize_t  size;
    hsize_t  free;
    unsigned nmesgs;
    unsigned nchunks;
} H5O_stat_t;
//! <!-- [H5O_stat_t_snip] -->
//! <!-- [H5O_info1_t_snip] -->
typedef struct H5O_info1_t {
    unsigned long
        fileno;
    haddr_t        addr;
    H5O_type_t     type;
    unsigned       rc;
    time_t         atime;
    time_t         mtime;
    time_t         ctime;
    time_t         btime;
    hsize_t        num_attrs;
    H5O_hdr_info_t hdr;
    struct {
        H5_ih_info_t obj;
        H5_ih_info_t attr;
    } meta_size;
} H5O_info1_t;
//! <!-- [H5O_info1_t_snip] -->
//! <!-- [H5O_iterate1_t_snip] -->
typedef herr_t (*H5O_iterate1_t)(hid_t obj, const char *name, const H5O_info1_t *info, void *op_data);
//! <!-- [H5O_iterate1_t_snip] -->
H5_DLL hid_t H5Oopen_by_addr(hid_t loc_id, haddr_t addr);
H5_DLL herr_t H5Oget_info1(hid_t loc_id, H5O_info1_t *oinfo);
H5_DLL herr_t H5Oget_info_by_name1(hid_t loc_id, const char *name, H5O_info1_t *oinfo, hid_t lapl_id);
H5_DLL herr_t H5Oget_info_by_idx1(hid_t loc_id, const char *group_name, H5_index_t idx_type,
                                  H5_iter_order_t order, hsize_t n, H5O_info1_t *oinfo, hid_t lapl_id);
H5_DLL herr_t H5Oget_info2(hid_t loc_id, H5O_info1_t *oinfo, unsigned fields);
H5_DLL herr_t H5Oget_info_by_name2(hid_t loc_id, const char *name, H5O_info1_t *oinfo, unsigned fields,
                                   hid_t lapl_id);
H5_DLL herr_t H5Oget_info_by_idx2(hid_t loc_id, const char *group_name, H5_index_t idx_type,
                                  H5_iter_order_t order, hsize_t n, H5O_info1_t *oinfo, unsigned fields,
                                  hid_t lapl_id);
H5_DLL herr_t H5Ovisit1(hid_t obj_id, H5_index_t idx_type, H5_iter_order_t order, H5O_iterate1_t op,
                        void *op_data);
H5_DLL herr_t H5Ovisit_by_name1(hid_t loc_id, const char *obj_name, H5_index_t idx_type,
                                H5_iter_order_t order, H5O_iterate1_t op, void *op_data, hid_t lapl_id);
H5_DLL herr_t H5Ovisit2(hid_t obj_id, H5_index_t idx_type, H5_iter_order_t order, H5O_iterate1_t op,
                        void *op_data, unsigned fields);
H5_DLL herr_t H5Ovisit_by_name2(hid_t loc_id, const char *obj_name, H5_index_t idx_type,
                                H5_iter_order_t order, H5O_iterate1_t op, void *op_data, unsigned fields,
                                hid_t lapl_id);
#endif
#ifdef __cplusplus
}
#endif
#endif
