"szabfok" <-
function (BE=c(2,4,5)) {

  #############################################################
  # 
  # TITLE:  szabfok()
  # AUTHOR: SANDOR KABOS, MODIFIED BY TARMO REMMEL
  # DATE:   27 NOV, 2003
  # CALLS:  
  # CALLED BY: teszt()
  # NEEDS:  VECTOR INDICATING DIMENSIONS OF QKEP INVOLVED IN 
  #           THE GIVEN HYPOTHESIS AT A GIVEN STEP OF THE
  #           DECOMPOSITION
  # NOTES:  USED IN THE COMPUTATION OF DEGREES OF FREEDOM
  #
  #############################################################

  # STORE DIMENSIONS AND NAMES OF QKEP TO DIM
  DIM <- .QND
  
  # STORE THE NUMBER OF DIMENSIONS IN QKEP REPRESENTED BY THE 
  # VARIABLE IDENTIFIERS IN BE
  BEDIM <- DIM[BE]
  
  # STORE ALL QKEP DIMENSION NAMES
  NEVEK <- names(DIM)
  
  # STORE THE CORRESPONDING DIMENSION NAMES LINKED WITH BE
  NEV <- NEVEK[BE]
  
  # STORE TRUE|FALSE FOR EACH NEV THAT IS A Z VARIABLE
  ZEK <- "Z"==substring(NEV,1,1)
  
  # STORE, FOR ALL NON Z-VARIABLES THE PRODUCT OF DIMENSIONS
  PXY <- prod(BEDIM[!ZEK])
  
  # STORE, FOR ALL Z-VARIABLES THE PRODUCT OF DIMENSIONS
  PZ <- prod(BEDIM[ZEK])
  
  # MULTIPLY THE DIMENSIONS OF ALL NON-ZVARIABLES BY (THE NUMBER OF Z DIMENSIONS MINUS 1)
  return(PXY*(PZ-1))
}

