% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcbs.R
\name{dcbs.alg}
\alias{dcbs.alg}
\title{Double CUSUM Binary Segmentation}
\usage{
dcbs.alg(
  x,
  cp.type = c(1, 2)[1],
  phi = 0.5,
  thr = NULL,
  trim = NULL,
  height = NULL,
  tau = NULL,
  temporal = TRUE,
  scales = NULL,
  diag = FALSE,
  B = 1000,
  q = 0.01,
  do.parallel = 4
)
}
\arguments{
\item{x}{input data matrix, with each row representing the component time series}

\item{cp.type}{\code{cp.type = 1} specifies change points in the mean, \code{cp.type = 2} specifies change points in the second-order structure}

\item{phi}{choice of parameter for weights in Double CUSUM statistic; 0 <= phi <= 1 or phi = -1 allowed with the latter leading to the DC statistic combining phi = 0 and phi = 1/2, see Section 4.1 of Cho (2016) for further details}

\item{thr}{pre-defined threshold values; when \code{thr = NULL}, bootstrap procedure is employed for the threshold selection; when \code{thr != NULL} and \code{cp.type = 1}, \code{length(thr)} should be one, if \code{cp.type = 2}, \code{length(thr)} should match \code{length(scales)}}

\item{trim}{length of the intervals trimmed off around the change point candidates; \code{trim = NULL} activates the default choice (\code{trim = round(log(dim(x)[2]))})}

\item{height}{maximum height of the binary tree; \code{height = NULL} activates the default choice (\code{height = floor(log(dim(x)[2], 2)/2)})}

\item{tau}{a vector containing the scaling constant for each row of \code{x}; if \code{tau = NULL}, a data-driven choice is made which takes into account the presence of possibly multiple mean shifts and temporal dependence when \code{temporal = TRUE}}

\item{temporal}{used when \code{cp.type = 1}; if \code{temporal = FALSE}, rows of \code{x} are scaled by \link{mad} estimates, if \code{temporal = TRUE}, their long-run variance estimates are used}

\item{scales}{used when \code{cp.type = 2}; negative integers representing Haar wavelet scales to be used for computing \code{nrow(x)*(nrow(x) + 1)/2} dimensional wavelet transformation of \code{x}; a small negative integer represents a fine scale}

\item{diag}{used when \code{cp.type = 2}; if \code{diag = TRUE}, only changes in the diagonal elements of the autocovariance matrices are searched for}

\item{B}{used when \code{is.null(thr)}; number of bootstrap samples for threshold selection}

\item{q}{used when \code{is.null(thr)}; indicates the quantile of bootstrap test statistics to be used for threshold selection}

\item{do.parallel}{used when \code{is.null(thr)}; number of copies of R running in parallel, if \code{do.parallel = 0}, \%do\% operator is used, see also \link{foreach}}
}
\value{
S3 \code{bin.tree} object, which contains the following fields:
   \item{tree}{a \link{list} object containing information about the nodes at which change points are detected}
   \item{mat}{matrix concatenation of the nodes of \code{tree}}
   \item{ecp}{estimated change points}
   \item{thr}{threshold used to construct the tree}
}
\description{
Perform the Double CUSUM Binary Segmentation algorithm detecting change points in the mean or second-order structure of the data.
}
\examples{
x <- matrix(rnorm(10*100), nrow = 10)
dcbs.alg(x, cp.type = 1, phi=.5, temporal = FALSE, do.parallel = 0)$ecp
\donttest{
x <- matrix(rnorm(100*300), nrow = 100)
x[1:10, 151:300] <- x[1:10, 151:300] + 1
dcbs.alg(x, cp.type = 1, phi=-1, temporal = FALSE, do.parallel = 0)$ecp
}
}
\references{
H. Cho (2016) change point detection in panel data via double CUSUM statistic. \emph{Electronic Journal of Statistics}, vol. 10, pp. 2000--2038.
}
