% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regulomeSearch.R, R/regulomeSummary.R
\name{regulomeSearch}
\alias{regulomeSearch}
\alias{regulomeSummary}
\title{This function queries RegulomeDB web-based tool 
and returns results in a data frame.}
\usage{
regulomeSearch(
  query = NULL,
  genomeAssembly = NULL,
  limit = 1000,
  timeout = 100
)

regulomeSummary(
  query = NULL,
  limit = 1000,
  genomeAssembly = NULL,
  timeout = 100
)
}
\arguments{
\item{query}{Query (a vector of rsIDs).}

\item{genomeAssembly}{Genome assembly built: can be GRCh37 or GRCh38}

\item{limit}{It controls how many variants will be queried and returned for a large region. It can be a number (1000 by default) or "all". 
Please note that large number or "all" may get yourself hurt because you could get timeout or may even crash the server.}

\item{timeout}{A \code{timeout} parameter for \code{httr::GET}.
Default: 100}
}
\value{
a list with the following items:
- guery_coordinates
- features
- regulome_score
- variants
- nearby_snps,
- assembly

a data frame (table)
}
\description{
This function queries RegulomeDB web-based tool 
and returns results in a data frame.

This function queries RegulomeDB web-based tool 
and returns results in a data frame.
}
\examples{
data <- regulomeSearch("rs4791078")
head(data)
data <- regulomeSummary(c("rs4791078","rs10048158"))
head(data)
}
