% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.importance.R
\name{plot.importance}
\alias{plot.importance}
\title{Plot of variable importance ranked by partial chi-square statistic}
\usage{
\method{plot}{importance}(x, y, ...)
}
\arguments{
\item{x}{importance object.}

\item{y}{not currently used.}

\item{...}{additional arguments.}
}
\value{
plot of variable importance, significant variables highlighted in red.
}
\description{
Plots an importance class object. Produces a dot chart that places the predictor
variable with the highest partial chi-square (Wald chi-square for individual
coefficients) at the bottom. It is a metric of the partial chi-square
minus its degrees of freedom (Harrell, 2015). Predictor variables
with significant p-values at the 0.05 alpha are highlighted red. Consider
graphical parameters of mar=c(4.2, 2, 3.5, 3) and oma = c(0, 0, 0, 3).
}
\examples{
# OLS regression
plot(importance(assess(mpg ~ hp + wt + cyl, data=mtcars, regression= "ols")$model))

# logistic regression
plot(importance(assess(vs~mpg+wt+hp, data=mtcars, regression= "logistic")$model))
}
\references{
Harrell, F. E., Jr. (2016). Regression Modeling Strategies. Springer
International Publishing. ISBN: 978-3-319-19424-0.
}
