% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_complexities.R
\name{autoplot.hagis.complexities}
\alias{autoplot.hagis.complexities}
\title{Plot hagis Complexities Objects}
\usage{
\method{autoplot}{hagis.complexities}(object, type, color = NULL, order = NULL, ...)
}
\arguments{
\item{object}{a \CRANpkg{hagis} \code{complexities} object generated by
\code{\link[=calculate_complexities]{calculate_complexities()}}. \code{Character}.}

\item{type}{a vector of values for which the bar plot is desired. Specify
whether to return a graph of the frequency of complexities as a percentage,
"\code{percentage}", or as the count, "\code{count}". \code{Character}.}

\item{color}{a named or hexadecimal color value to use for the bar color}

\item{order}{sort the x-axis of the bar chart by ascending or descending
order of \code{frequency}. Accepts \code{ascending} or \code{descending} input values.
Defaults to \code{complexity} value. \code{Character}.}

\item{...}{passed to the chosen \code{geom(s)}}
}
\value{
A \CRANpkg{ggplot2} object
}
\description{
Creates a \CRANpkg{ggplot2} object of the frequency of
complexity (percent per complexity) or a \CRANpkg{ggplot2} object of the
distribution (number per complexity) calculated by
\code{\link[=calculate_complexities]{calculate_complexities()}}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Using the built-in data set, `P_sojae_survey`
data(P_sojae_survey)

# calculate susceptibilities with a 60 \% cutoff value
complexities <- calculate_complexities(x = P_sojae_survey,
                                       cutoff = 60,
                                       control = "susceptible",
                                       sample = "Isolate",
                                       gene = "Rps",
                                       perc_susc = "perc.susc")

# Visualize the distribution (count or actual values)
autoplot(complexities, type = "count")

# Visualize the frequency (percentages)
autoplot(complexities, type = "percentage")
\dontshow{\}) # examplesIf}
}
