% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svol_triangle.R
\name{svol_triangle}
\alias{svol_triangle}
\title{Calculate signed volume of triangle}
\usage{
svol_triangle(XYZCoords)
}
\arguments{
\item{XYZCoords}{A dataframe with XYZ coordinates of three points in following order: X1,X2,X3,Y1,Y2,Y3,Z1,Z2,Z3}
}
\value{
Value for the signed volume of a triangle.
}
\description{
Calculates the signed volume of a triangle based on a set of XYZCoords.
Signed volume means that volumes can take on a negative value depending on whether the surface normal
of the triangle is facing towards or away from the origin. When all positive and negative volumes
are integrated across the entire mesh, these values cancel out so that the final volume is an approximation
of the total volume of the mesh.
}
\examples{
svol_triangle(c(X1 = 1, X2 = 2, X3 = 3 , Y1 = 1, Y2 = 2, Y3 = 1, Z1 = 1, Z2 = 1, Z3 = 1))
}
