% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mesh_to_dem.R
\name{mesh_to_dem}
\alias{mesh_to_dem}
\title{Transform 3D mesh to DEM}
\usage{
mesh_to_dem(mesh, res, fill = TRUE)
}
\arguments{
\item{mesh}{A mesh3d object.}

\item{res}{(Optional) The desired DEM resolution in same units at the 3D mesh.}

\item{fill}{Logical. Fill \code{NA} values in raster with minimum value?}
}
\value{
A dem of class RasterLayer.
}
\description{
Turns a 3D mesh file into a Digital Elevation Model (DEM) of class RasterLayer
format.
}
\details{
The function rasterizes uses the vertices of the mesh file.
If resolution is not
given, it is calculated by finding the maximum nearest neighbor
of vertices projected
on the \code{xy} plane. \code{fill} is used when irregular 3D meshes
result in \code{NA} values in
raster cells. The default is to fill these cells with the
minimum, non-\code{NA} raster value.
}
\examples{
dem <- mesh_to_dem(mcap)
raster::plot(dem)

dem <- mesh_to_dem(mcap, res = 0.05)
raster::plot(dem)

# Don't fill empty raster cells
dem <- mesh_to_dem(mcap, res = 0.02, fill = FALSE)
raster::plot(dem)

}
