/*
    hBayesDM is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    hBayesDM is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with hBayesDM.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.18.0

#include <stan/model/model_header.hpp>

namespace model_rdt_happiness_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_rdt_happiness");
    reader.add_event(0, 0, "include", "/pre/license.stan");
    reader.add_event(0, 0, "start", "/pre/license.stan");
    reader.add_event(14, 14, "end", "/pre/license.stan");
    reader.add_event(14, 1, "restart", "model_rdt_happiness");
    reader.add_event(160, 145, "end", "model_rdt_happiness");
    return reader;
}

#include <meta_header.hpp>
 class model_rdt_happiness : public prob_grad {
private:
    int N;
    int T;
    vector<int> Tsubj;
    vector<vector<double> > gain;
    vector<vector<double> > loss;
    vector<vector<double> > cert;
    vector<vector<int> > type;
    vector<vector<int> > gamble;
    vector<vector<double> > outcome;
    vector<vector<double> > happy;
    vector<vector<double> > RT_happy;
public:
    model_rdt_happiness(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_rdt_happiness(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;

        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_rdt_happiness_namespace::model_rdt_happiness";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 17;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            current_statement_begin__ = 18;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            current_statement_begin__ = 19;
            validate_non_negative_index("Tsubj", "N", N);
            context__.validate_dims("data initialization", "Tsubj", "int", context__.to_vec(N));
            validate_non_negative_index("Tsubj", "N", N);
            Tsubj = std::vector<int>(N,int(0));
            vals_i__ = context__.vals_i("Tsubj");
            pos__ = 0;
            size_t Tsubj_limit_0__ = N;
            for (size_t i_0__ = 0; i_0__ < Tsubj_limit_0__; ++i_0__) {
                Tsubj[i_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 20;
            validate_non_negative_index("gain", "N", N);
            validate_non_negative_index("gain", "T", T);
            context__.validate_dims("data initialization", "gain", "double", context__.to_vec(N,T));
            validate_non_negative_index("gain", "N", N);
            validate_non_negative_index("gain", "T", T);
            gain = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
            vals_r__ = context__.vals_r("gain");
            pos__ = 0;
            size_t gain_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < gain_limit_1__; ++i_1__) {
                size_t gain_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < gain_limit_0__; ++i_0__) {
                    gain[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 21;
            validate_non_negative_index("loss", "N", N);
            validate_non_negative_index("loss", "T", T);
            context__.validate_dims("data initialization", "loss", "double", context__.to_vec(N,T));
            validate_non_negative_index("loss", "N", N);
            validate_non_negative_index("loss", "T", T);
            loss = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
            vals_r__ = context__.vals_r("loss");
            pos__ = 0;
            size_t loss_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < loss_limit_1__; ++i_1__) {
                size_t loss_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < loss_limit_0__; ++i_0__) {
                    loss[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 22;
            validate_non_negative_index("cert", "N", N);
            validate_non_negative_index("cert", "T", T);
            context__.validate_dims("data initialization", "cert", "double", context__.to_vec(N,T));
            validate_non_negative_index("cert", "N", N);
            validate_non_negative_index("cert", "T", T);
            cert = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
            vals_r__ = context__.vals_r("cert");
            pos__ = 0;
            size_t cert_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < cert_limit_1__; ++i_1__) {
                size_t cert_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < cert_limit_0__; ++i_0__) {
                    cert[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 23;
            validate_non_negative_index("type", "N", N);
            validate_non_negative_index("type", "T", T);
            context__.validate_dims("data initialization", "type", "int", context__.to_vec(N,T));
            validate_non_negative_index("type", "N", N);
            validate_non_negative_index("type", "T", T);
            type = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
            vals_i__ = context__.vals_i("type");
            pos__ = 0;
            size_t type_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < type_limit_1__; ++i_1__) {
                size_t type_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < type_limit_0__; ++i_0__) {
                    type[i_0__][i_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 24;
            validate_non_negative_index("gamble", "N", N);
            validate_non_negative_index("gamble", "T", T);
            context__.validate_dims("data initialization", "gamble", "int", context__.to_vec(N,T));
            validate_non_negative_index("gamble", "N", N);
            validate_non_negative_index("gamble", "T", T);
            gamble = std::vector<std::vector<int> >(N,std::vector<int>(T,int(0)));
            vals_i__ = context__.vals_i("gamble");
            pos__ = 0;
            size_t gamble_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < gamble_limit_1__; ++i_1__) {
                size_t gamble_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < gamble_limit_0__; ++i_0__) {
                    gamble[i_0__][i_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 25;
            validate_non_negative_index("outcome", "N", N);
            validate_non_negative_index("outcome", "T", T);
            context__.validate_dims("data initialization", "outcome", "double", context__.to_vec(N,T));
            validate_non_negative_index("outcome", "N", N);
            validate_non_negative_index("outcome", "T", T);
            outcome = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
            vals_r__ = context__.vals_r("outcome");
            pos__ = 0;
            size_t outcome_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < outcome_limit_1__; ++i_1__) {
                size_t outcome_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < outcome_limit_0__; ++i_0__) {
                    outcome[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 26;
            validate_non_negative_index("happy", "N", N);
            validate_non_negative_index("happy", "T", T);
            context__.validate_dims("data initialization", "happy", "double", context__.to_vec(N,T));
            validate_non_negative_index("happy", "N", N);
            validate_non_negative_index("happy", "T", T);
            happy = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
            vals_r__ = context__.vals_r("happy");
            pos__ = 0;
            size_t happy_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < happy_limit_1__; ++i_1__) {
                size_t happy_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < happy_limit_0__; ++i_0__) {
                    happy[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 27;
            validate_non_negative_index("RT_happy", "N", N);
            validate_non_negative_index("RT_happy", "T", T);
            context__.validate_dims("data initialization", "RT_happy", "double", context__.to_vec(N,T));
            validate_non_negative_index("RT_happy", "N", N);
            validate_non_negative_index("RT_happy", "T", T);
            RT_happy = std::vector<std::vector<double> >(N,std::vector<double>(T,double(0)));
            vals_r__ = context__.vals_r("RT_happy");
            pos__ = 0;
            size_t RT_happy_limit_1__ = T;
            for (size_t i_1__ = 0; i_1__ < RT_happy_limit_1__; ++i_1__) {
                size_t RT_happy_limit_0__ = N;
                for (size_t i_0__ = 0; i_0__ < RT_happy_limit_0__; ++i_0__) {
                    RT_happy[i_0__][i_1__] = vals_r__[pos__++];
                }
            }

            // validate, data variables
            current_statement_begin__ = 17;
            check_greater_or_equal(function__,"N",N,1);
            current_statement_begin__ = 18;
            check_greater_or_equal(function__,"T",T,1);
            current_statement_begin__ = 19;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                check_greater_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],1);
                check_less_or_equal(function__,"Tsubj[k0__]",Tsubj[k0__],T);
            }
            current_statement_begin__ = 20;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"gain[k0__][k1__]",gain[k0__][k1__],0);
                }
            }
            current_statement_begin__ = 21;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"loss[k0__][k1__]",loss[k0__][k1__],0);
                }
            }
            current_statement_begin__ = 22;
            current_statement_begin__ = 23;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"type[k0__][k1__]",type[k0__][k1__],-(1));
                    check_less_or_equal(function__,"type[k0__][k1__]",type[k0__][k1__],1);
                }
            }
            current_statement_begin__ = 24;
            for (int k0__ = 0; k0__ < N; ++k0__) {
                for (int k1__ = 0; k1__ < T; ++k1__) {
                    check_greater_or_equal(function__,"gamble[k0__][k1__]",gamble[k0__][k1__],-(1));
                    check_less_or_equal(function__,"gamble[k0__][k1__]",gamble[k0__][k1__],1);
                }
            }
            current_statement_begin__ = 25;
            current_statement_begin__ = 26;
            current_statement_begin__ = 27;
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 32;
            validate_non_negative_index("mu_pr", "6", 6);
            num_params_r__ += 6;
            current_statement_begin__ = 33;
            validate_non_negative_index("sigma", "6", 6);
            num_params_r__ += 6;
            current_statement_begin__ = 34;
            validate_non_negative_index("w0_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 35;
            validate_non_negative_index("w1_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 36;
            validate_non_negative_index("w2_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 37;
            validate_non_negative_index("w3_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 38;
            validate_non_negative_index("gam_pr", "N", N);
            num_params_r__ += N;
            current_statement_begin__ = 39;
            validate_non_negative_index("sig_pr", "N", N);
            num_params_r__ += N;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_rdt_happiness() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu_pr")))
            throw std::runtime_error("variable mu_pr missing");
        vals_r__ = context__.vals_r("mu_pr");
        pos__ = 0U;
        validate_non_negative_index("mu_pr", "6", 6);
        context__.validate_dims("initialization", "mu_pr", "vector_d", context__.to_vec(6));
        vector_d mu_pr(static_cast<Eigen::VectorXd::Index>(6));
        for (int j1__ = 0U; j1__ < 6; ++j1__)
            mu_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(mu_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu_pr: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        validate_non_negative_index("sigma", "6", 6);
        context__.validate_dims("initialization", "sigma", "vector_d", context__.to_vec(6));
        vector_d sigma(static_cast<Eigen::VectorXd::Index>(6));
        for (int j1__ = 0U; j1__ < 6; ++j1__)
            sigma(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_lb_unconstrain(0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("w0_pr")))
            throw std::runtime_error("variable w0_pr missing");
        vals_r__ = context__.vals_r("w0_pr");
        pos__ = 0U;
        validate_non_negative_index("w0_pr", "N", N);
        context__.validate_dims("initialization", "w0_pr", "vector_d", context__.to_vec(N));
        vector_d w0_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            w0_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(w0_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable w0_pr: ") + e.what());
        }

        if (!(context__.contains_r("w1_pr")))
            throw std::runtime_error("variable w1_pr missing");
        vals_r__ = context__.vals_r("w1_pr");
        pos__ = 0U;
        validate_non_negative_index("w1_pr", "N", N);
        context__.validate_dims("initialization", "w1_pr", "vector_d", context__.to_vec(N));
        vector_d w1_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            w1_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(w1_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable w1_pr: ") + e.what());
        }

        if (!(context__.contains_r("w2_pr")))
            throw std::runtime_error("variable w2_pr missing");
        vals_r__ = context__.vals_r("w2_pr");
        pos__ = 0U;
        validate_non_negative_index("w2_pr", "N", N);
        context__.validate_dims("initialization", "w2_pr", "vector_d", context__.to_vec(N));
        vector_d w2_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            w2_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(w2_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable w2_pr: ") + e.what());
        }

        if (!(context__.contains_r("w3_pr")))
            throw std::runtime_error("variable w3_pr missing");
        vals_r__ = context__.vals_r("w3_pr");
        pos__ = 0U;
        validate_non_negative_index("w3_pr", "N", N);
        context__.validate_dims("initialization", "w3_pr", "vector_d", context__.to_vec(N));
        vector_d w3_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            w3_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(w3_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable w3_pr: ") + e.what());
        }

        if (!(context__.contains_r("gam_pr")))
            throw std::runtime_error("variable gam_pr missing");
        vals_r__ = context__.vals_r("gam_pr");
        pos__ = 0U;
        validate_non_negative_index("gam_pr", "N", N);
        context__.validate_dims("initialization", "gam_pr", "vector_d", context__.to_vec(N));
        vector_d gam_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            gam_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(gam_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable gam_pr: ") + e.what());
        }

        if (!(context__.contains_r("sig_pr")))
            throw std::runtime_error("variable sig_pr missing");
        vals_r__ = context__.vals_r("sig_pr");
        pos__ = 0U;
        validate_non_negative_index("sig_pr", "N", N);
        context__.validate_dims("initialization", "sig_pr", "vector_d", context__.to_vec(N));
        vector_d sig_pr(static_cast<Eigen::VectorXd::Index>(N));
        for (int j1__ = 0U; j1__ < N; ++j1__)
            sig_pr(j1__) = vals_r__[pos__++];
        try {
            writer__.vector_unconstrain(sig_pr);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sig_pr: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        typedef T__ local_scalar_t__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  mu_pr;
            (void) mu_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                mu_pr = in__.vector_constrain(6,lp__);
            else
                mu_pr = in__.vector_constrain(6);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.vector_lb_constrain(0,6,lp__);
            else
                sigma = in__.vector_lb_constrain(0,6);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  w0_pr;
            (void) w0_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                w0_pr = in__.vector_constrain(N,lp__);
            else
                w0_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  w1_pr;
            (void) w1_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                w1_pr = in__.vector_constrain(N,lp__);
            else
                w1_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  w2_pr;
            (void) w2_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                w2_pr = in__.vector_constrain(N,lp__);
            else
                w2_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  w3_pr;
            (void) w3_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                w3_pr = in__.vector_constrain(N,lp__);
            else
                w3_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  gam_pr;
            (void) gam_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                gam_pr = in__.vector_constrain(N,lp__);
            else
                gam_pr = in__.vector_constrain(N);

            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  sig_pr;
            (void) sig_pr;  // dummy to suppress unused var warning
            if (jacobian__)
                sig_pr = in__.vector_constrain(N,lp__);
            else
                sig_pr = in__.vector_constrain(N);


            // transformed parameters
            current_statement_begin__ = 42;
            validate_non_negative_index("w0", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  w0(static_cast<Eigen::VectorXd::Index>(N));
            (void) w0;  // dummy to suppress unused var warning

            stan::math::initialize(w0, DUMMY_VAR__);
            stan::math::fill(w0,DUMMY_VAR__);
            current_statement_begin__ = 43;
            validate_non_negative_index("w1", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  w1(static_cast<Eigen::VectorXd::Index>(N));
            (void) w1;  // dummy to suppress unused var warning

            stan::math::initialize(w1, DUMMY_VAR__);
            stan::math::fill(w1,DUMMY_VAR__);
            current_statement_begin__ = 44;
            validate_non_negative_index("w2", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  w2(static_cast<Eigen::VectorXd::Index>(N));
            (void) w2;  // dummy to suppress unused var warning

            stan::math::initialize(w2, DUMMY_VAR__);
            stan::math::fill(w2,DUMMY_VAR__);
            current_statement_begin__ = 45;
            validate_non_negative_index("w3", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  w3(static_cast<Eigen::VectorXd::Index>(N));
            (void) w3;  // dummy to suppress unused var warning

            stan::math::initialize(w3, DUMMY_VAR__);
            stan::math::fill(w3,DUMMY_VAR__);
            current_statement_begin__ = 46;
            validate_non_negative_index("gam", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  gam(static_cast<Eigen::VectorXd::Index>(N));
            (void) gam;  // dummy to suppress unused var warning

            stan::math::initialize(gam, DUMMY_VAR__);
            stan::math::fill(gam,DUMMY_VAR__);
            current_statement_begin__ = 47;
            validate_non_negative_index("sig", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  sig(static_cast<Eigen::VectorXd::Index>(N));
            (void) sig;  // dummy to suppress unused var warning

            stan::math::initialize(sig, DUMMY_VAR__);
            stan::math::fill(sig,DUMMY_VAR__);


            current_statement_begin__ = 49;
            stan::math::assign(w0, add(get_base1(mu_pr,1,"mu_pr",1),multiply(get_base1(sigma,1,"sigma",1),w0_pr)));
            current_statement_begin__ = 50;
            stan::math::assign(w1, add(get_base1(mu_pr,2,"mu_pr",1),multiply(get_base1(sigma,2,"sigma",1),w1_pr)));
            current_statement_begin__ = 51;
            stan::math::assign(w2, add(get_base1(mu_pr,3,"mu_pr",1),multiply(get_base1(sigma,3,"sigma",1),w2_pr)));
            current_statement_begin__ = 52;
            stan::math::assign(w3, add(get_base1(mu_pr,4,"mu_pr",1),multiply(get_base1(sigma,4,"sigma",1),w3_pr)));
            current_statement_begin__ = 54;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 55;
                stan::model::assign(gam, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,5,"mu_pr",1) + (get_base1(sigma,5,"sigma",1) * get_base1(gam_pr,i,"gam_pr",1)))), 
                            "assigning variable gam");
            }
            current_statement_begin__ = 57;
            stan::math::assign(sig, stan::math::exp(add(get_base1(mu_pr,6,"mu_pr",1),multiply(get_base1(sigma,6,"sigma",1),sig_pr))));

            // validate transformed parameters
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(w0(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: w0" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(w1(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: w1" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(w2(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: w2" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(w3(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: w3" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(gam(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: gam" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < N; ++i0__) {
                if (stan::math::is_uninitialized(sig(i0__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: sig" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 42;
            current_statement_begin__ = 43;
            current_statement_begin__ = 44;
            current_statement_begin__ = 45;
            current_statement_begin__ = 46;
            check_greater_or_equal(function__,"gam",gam,0);
            check_less_or_equal(function__,"gam",gam,1);
            current_statement_begin__ = 47;
            check_greater_or_equal(function__,"sig",sig,0);

            // model body

            current_statement_begin__ = 60;
            lp_accum__.add(normal_log<propto__>(mu_pr, 0, 1.0));
            current_statement_begin__ = 61;
            lp_accum__.add(normal_log<propto__>(sigma, 0, 0.20000000000000001));
            current_statement_begin__ = 64;
            lp_accum__.add(normal_log<propto__>(w0_pr, 0, 1.0));
            current_statement_begin__ = 65;
            lp_accum__.add(normal_log<propto__>(w1_pr, 0, 1.0));
            current_statement_begin__ = 66;
            lp_accum__.add(normal_log<propto__>(w2_pr, 0, 1.0));
            current_statement_begin__ = 67;
            lp_accum__.add(normal_log<propto__>(w3_pr, 0, 1.0));
            current_statement_begin__ = 68;
            lp_accum__.add(normal_log<propto__>(gam_pr, 0, 1.0));
            current_statement_begin__ = 69;
            lp_accum__.add(normal_log<propto__>(sig_pr, 0, 1.0));
            current_statement_begin__ = 71;
            for (int i = 1; i <= N; ++i) {
                {
                current_statement_begin__ = 72;
                local_scalar_t__ cert_sum;
                (void) cert_sum;  // dummy to suppress unused var warning

                stan::math::initialize(cert_sum, DUMMY_VAR__);
                stan::math::fill(cert_sum,DUMMY_VAR__);
                current_statement_begin__ = 73;
                local_scalar_t__ ev_sum;
                (void) ev_sum;  // dummy to suppress unused var warning

                stan::math::initialize(ev_sum, DUMMY_VAR__);
                stan::math::fill(ev_sum,DUMMY_VAR__);
                current_statement_begin__ = 74;
                local_scalar_t__ rpe_sum;
                (void) rpe_sum;  // dummy to suppress unused var warning

                stan::math::initialize(rpe_sum, DUMMY_VAR__);
                stan::math::fill(rpe_sum,DUMMY_VAR__);


                current_statement_begin__ = 77;
                stan::math::assign(cert_sum, 0);
                current_statement_begin__ = 78;
                stan::math::assign(ev_sum, 0);
                current_statement_begin__ = 79;
                stan::math::assign(rpe_sum, 0);
                current_statement_begin__ = 81;
                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                    current_statement_begin__ = 82;
                    if (as_bool((primitive_value(logical_eq(t,1)) || primitive_value((primitive_value(logical_gt(t,1)) && primitive_value(logical_neq(get_base1(get_base1(RT_happy,i,"RT_happy",1),t,"RT_happy",2),get_base1(get_base1(RT_happy,i,"RT_happy",1),(t - 1),"RT_happy",2)))))))) {

                        current_statement_begin__ = 83;
                        lp_accum__.add(normal_log<propto__>(get_base1(get_base1(happy,i,"happy",1),t,"happy",2), (((get_base1(w0,i,"w0",1) + (get_base1(w1,i,"w1",1) * cert_sum)) + (get_base1(w2,i,"w2",1) * ev_sum)) + (get_base1(w3,i,"w3",1) * rpe_sum)), get_base1(sig,i,"sig",1)));
                    }
                    current_statement_begin__ = 86;
                    if (as_bool(logical_eq(get_base1(get_base1(gamble,i,"gamble",1),t,"gamble",2),0))) {

                        current_statement_begin__ = 87;
                        stan::math::assign(cert_sum, (cert_sum + (get_base1(get_base1(type,i,"type",1),t,"type",2) * get_base1(get_base1(cert,i,"cert",1),t,"cert",2))));
                    } else {

                        current_statement_begin__ = 89;
                        stan::math::assign(ev_sum, (ev_sum + (0.5 * (get_base1(get_base1(gain,i,"gain",1),t,"gain",2) - get_base1(get_base1(loss,i,"loss",1),t,"loss",2)))));
                        current_statement_begin__ = 90;
                        stan::math::assign(rpe_sum, (rpe_sum + (get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2) - (0.5 * (get_base1(get_base1(gain,i,"gain",1),t,"gain",2) - get_base1(get_base1(loss,i,"loss",1),t,"loss",2))))));
                    }
                    current_statement_begin__ = 93;
                    stan::math::assign(cert_sum, (cert_sum * get_base1(gam,i,"gam",1)));
                    current_statement_begin__ = 94;
                    stan::math::assign(ev_sum, (ev_sum * get_base1(gam,i,"gam",1)));
                    current_statement_begin__ = 95;
                    stan::math::assign(rpe_sum, (rpe_sum * get_base1(gam,i,"gam",1)));
                }
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu_pr");
        names__.push_back("sigma");
        names__.push_back("w0_pr");
        names__.push_back("w1_pr");
        names__.push_back("w2_pr");
        names__.push_back("w3_pr");
        names__.push_back("gam_pr");
        names__.push_back("sig_pr");
        names__.push_back("w0");
        names__.push_back("w1");
        names__.push_back("w2");
        names__.push_back("w3");
        names__.push_back("gam");
        names__.push_back("sig");
        names__.push_back("mu_w0");
        names__.push_back("mu_w1");
        names__.push_back("mu_w2");
        names__.push_back("mu_w3");
        names__.push_back("mu_gam");
        names__.push_back("mu_sig");
        names__.push_back("log_lik");
        names__.push_back("y_pred");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(6);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(6);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(N);
        dims__.push_back(T);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;

        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__,params_i__);
        static const char* function__ = "model_rdt_happiness_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector_d mu_pr = in__.vector_constrain(6);
        vector_d sigma = in__.vector_lb_constrain(0,6);
        vector_d w0_pr = in__.vector_constrain(N);
        vector_d w1_pr = in__.vector_constrain(N);
        vector_d w2_pr = in__.vector_constrain(N);
        vector_d w3_pr = in__.vector_constrain(N);
        vector_d gam_pr = in__.vector_constrain(N);
        vector_d sig_pr = in__.vector_constrain(N);
            for (int k_0__ = 0; k_0__ < 6; ++k_0__) {
            vars__.push_back(mu_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < 6; ++k_0__) {
            vars__.push_back(sigma[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(w0_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(w1_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(w2_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(w3_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(gam_pr[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(sig_pr[k_0__]);
            }

        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 42;
            validate_non_negative_index("w0", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  w0(static_cast<Eigen::VectorXd::Index>(N));
            (void) w0;  // dummy to suppress unused var warning

            stan::math::initialize(w0, DUMMY_VAR__);
            stan::math::fill(w0,DUMMY_VAR__);
            current_statement_begin__ = 43;
            validate_non_negative_index("w1", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  w1(static_cast<Eigen::VectorXd::Index>(N));
            (void) w1;  // dummy to suppress unused var warning

            stan::math::initialize(w1, DUMMY_VAR__);
            stan::math::fill(w1,DUMMY_VAR__);
            current_statement_begin__ = 44;
            validate_non_negative_index("w2", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  w2(static_cast<Eigen::VectorXd::Index>(N));
            (void) w2;  // dummy to suppress unused var warning

            stan::math::initialize(w2, DUMMY_VAR__);
            stan::math::fill(w2,DUMMY_VAR__);
            current_statement_begin__ = 45;
            validate_non_negative_index("w3", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  w3(static_cast<Eigen::VectorXd::Index>(N));
            (void) w3;  // dummy to suppress unused var warning

            stan::math::initialize(w3, DUMMY_VAR__);
            stan::math::fill(w3,DUMMY_VAR__);
            current_statement_begin__ = 46;
            validate_non_negative_index("gam", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  gam(static_cast<Eigen::VectorXd::Index>(N));
            (void) gam;  // dummy to suppress unused var warning

            stan::math::initialize(gam, DUMMY_VAR__);
            stan::math::fill(gam,DUMMY_VAR__);
            current_statement_begin__ = 47;
            validate_non_negative_index("sig", "N", N);
            Eigen::Matrix<local_scalar_t__,Eigen::Dynamic,1>  sig(static_cast<Eigen::VectorXd::Index>(N));
            (void) sig;  // dummy to suppress unused var warning

            stan::math::initialize(sig, DUMMY_VAR__);
            stan::math::fill(sig,DUMMY_VAR__);


            current_statement_begin__ = 49;
            stan::math::assign(w0, add(get_base1(mu_pr,1,"mu_pr",1),multiply(get_base1(sigma,1,"sigma",1),w0_pr)));
            current_statement_begin__ = 50;
            stan::math::assign(w1, add(get_base1(mu_pr,2,"mu_pr",1),multiply(get_base1(sigma,2,"sigma",1),w1_pr)));
            current_statement_begin__ = 51;
            stan::math::assign(w2, add(get_base1(mu_pr,3,"mu_pr",1),multiply(get_base1(sigma,3,"sigma",1),w2_pr)));
            current_statement_begin__ = 52;
            stan::math::assign(w3, add(get_base1(mu_pr,4,"mu_pr",1),multiply(get_base1(sigma,4,"sigma",1),w3_pr)));
            current_statement_begin__ = 54;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 55;
                stan::model::assign(gam, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            Phi_approx((get_base1(mu_pr,5,"mu_pr",1) + (get_base1(sigma,5,"sigma",1) * get_base1(gam_pr,i,"gam_pr",1)))), 
                            "assigning variable gam");
            }
            current_statement_begin__ = 57;
            stan::math::assign(sig, stan::math::exp(add(get_base1(mu_pr,6,"mu_pr",1),multiply(get_base1(sigma,6,"sigma",1),sig_pr))));

            // validate transformed parameters
            current_statement_begin__ = 42;
            current_statement_begin__ = 43;
            current_statement_begin__ = 44;
            current_statement_begin__ = 45;
            current_statement_begin__ = 46;
            check_greater_or_equal(function__,"gam",gam,0);
            check_less_or_equal(function__,"gam",gam,1);
            current_statement_begin__ = 47;
            check_greater_or_equal(function__,"sig",sig,0);

            // write transformed parameters
            if (include_tparams__) {
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(w0[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(w1[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(w2[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(w3[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(gam[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(sig[k_0__]);
            }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 100;
            local_scalar_t__ mu_w0;
            (void) mu_w0;  // dummy to suppress unused var warning

            stan::math::initialize(mu_w0, DUMMY_VAR__);
            stan::math::fill(mu_w0,DUMMY_VAR__);
            current_statement_begin__ = 101;
            local_scalar_t__ mu_w1;
            (void) mu_w1;  // dummy to suppress unused var warning

            stan::math::initialize(mu_w1, DUMMY_VAR__);
            stan::math::fill(mu_w1,DUMMY_VAR__);
            current_statement_begin__ = 102;
            local_scalar_t__ mu_w2;
            (void) mu_w2;  // dummy to suppress unused var warning

            stan::math::initialize(mu_w2, DUMMY_VAR__);
            stan::math::fill(mu_w2,DUMMY_VAR__);
            current_statement_begin__ = 103;
            local_scalar_t__ mu_w3;
            (void) mu_w3;  // dummy to suppress unused var warning

            stan::math::initialize(mu_w3, DUMMY_VAR__);
            stan::math::fill(mu_w3,DUMMY_VAR__);
            current_statement_begin__ = 104;
            local_scalar_t__ mu_gam;
            (void) mu_gam;  // dummy to suppress unused var warning

            stan::math::initialize(mu_gam, DUMMY_VAR__);
            stan::math::fill(mu_gam,DUMMY_VAR__);
            current_statement_begin__ = 105;
            local_scalar_t__ mu_sig;
            (void) mu_sig;  // dummy to suppress unused var warning

            stan::math::initialize(mu_sig, DUMMY_VAR__);
            stan::math::fill(mu_sig,DUMMY_VAR__);
            current_statement_begin__ = 107;
            validate_non_negative_index("log_lik", "N", N);
            vector<local_scalar_t__> log_lik(N);
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik,DUMMY_VAR__);
            current_statement_begin__ = 110;
            validate_non_negative_index("y_pred", "N", N);
            validate_non_negative_index("y_pred", "T", T);
            vector<vector<local_scalar_t__> > y_pred(N, (vector<local_scalar_t__>(T)));
            stan::math::initialize(y_pred, DUMMY_VAR__);
            stan::math::fill(y_pred,DUMMY_VAR__);


            current_statement_begin__ = 113;
            for (int i = 1; i <= N; ++i) {

                current_statement_begin__ = 114;
                for (int t = 1; t <= T; ++t) {

                    current_statement_begin__ = 115;
                    stan::model::assign(y_pred, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                -(1), 
                                "assigning variable y_pred");
                }
            }
            current_statement_begin__ = 119;
            stan::math::assign(mu_w0, get_base1(mu_pr,1,"mu_pr",1));
            current_statement_begin__ = 120;
            stan::math::assign(mu_w1, get_base1(mu_pr,2,"mu_pr",1));
            current_statement_begin__ = 121;
            stan::math::assign(mu_w2, get_base1(mu_pr,3,"mu_pr",1));
            current_statement_begin__ = 122;
            stan::math::assign(mu_w3, get_base1(mu_pr,4,"mu_pr",1));
            current_statement_begin__ = 123;
            stan::math::assign(mu_gam, Phi_approx(get_base1(mu_pr,5,"mu_pr",1)));
            current_statement_begin__ = 124;
            stan::math::assign(mu_sig, stan::math::exp(get_base1(mu_pr,6,"mu_pr",1)));

            current_statement_begin__ = 128;
            for (int i = 1; i <= N; ++i) {
                {
                current_statement_begin__ = 129;
                local_scalar_t__ cert_sum;
                (void) cert_sum;  // dummy to suppress unused var warning

                stan::math::initialize(cert_sum, DUMMY_VAR__);
                stan::math::fill(cert_sum,DUMMY_VAR__);
                current_statement_begin__ = 130;
                local_scalar_t__ ev_sum;
                (void) ev_sum;  // dummy to suppress unused var warning

                stan::math::initialize(ev_sum, DUMMY_VAR__);
                stan::math::fill(ev_sum,DUMMY_VAR__);
                current_statement_begin__ = 131;
                local_scalar_t__ rpe_sum;
                (void) rpe_sum;  // dummy to suppress unused var warning

                stan::math::initialize(rpe_sum, DUMMY_VAR__);
                stan::math::fill(rpe_sum,DUMMY_VAR__);


                current_statement_begin__ = 133;
                stan::model::assign(log_lik, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            0, 
                            "assigning variable log_lik");
                current_statement_begin__ = 135;
                stan::math::assign(cert_sum, 0);
                current_statement_begin__ = 136;
                stan::math::assign(ev_sum, 0);
                current_statement_begin__ = 137;
                stan::math::assign(rpe_sum, 0);
                current_statement_begin__ = 139;
                for (int t = 1; t <= get_base1(Tsubj,i,"Tsubj",1); ++t) {

                    current_statement_begin__ = 140;
                    if (as_bool((primitive_value(logical_eq(t,1)) || primitive_value((primitive_value(logical_gt(t,1)) && primitive_value(logical_neq(get_base1(get_base1(RT_happy,i,"RT_happy",1),t,"RT_happy",2),get_base1(get_base1(RT_happy,i,"RT_happy",1),(t - 1),"RT_happy",2)))))))) {

                        current_statement_begin__ = 141;
                        stan::model::assign(log_lik, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    (stan::model::rvalue(log_lik, stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), "log_lik") + normal_log(get_base1(get_base1(happy,i,"happy",1),t,"happy",2),(((get_base1(w0,i,"w0",1) + (get_base1(w1,i,"w1",1) * cert_sum)) + (get_base1(w2,i,"w2",1) * ev_sum)) + (get_base1(w3,i,"w3",1) * rpe_sum)),get_base1(sig,i,"sig",1))), 
                                    "assigning variable log_lik");
                        current_statement_begin__ = 142;
                        stan::model::assign(y_pred, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                    normal_rng((((get_base1(w0,i,"w0",1) + (get_base1(w1,i,"w1",1) * cert_sum)) + (get_base1(w2,i,"w2",1) * ev_sum)) + (get_base1(w3,i,"w3",1) * rpe_sum)),get_base1(sig,i,"sig",1), base_rng__), 
                                    "assigning variable y_pred");
                    }
                    current_statement_begin__ = 145;
                    if (as_bool(logical_eq(get_base1(get_base1(gamble,i,"gamble",1),t,"gamble",2),0))) {

                        current_statement_begin__ = 146;
                        stan::math::assign(cert_sum, (cert_sum + (get_base1(get_base1(type,i,"type",1),t,"type",2) * get_base1(get_base1(cert,i,"cert",1),t,"cert",2))));
                    } else {

                        current_statement_begin__ = 148;
                        stan::math::assign(ev_sum, (ev_sum + (0.5 * (get_base1(get_base1(gain,i,"gain",1),t,"gain",2) - get_base1(get_base1(loss,i,"loss",1),t,"loss",2)))));
                        current_statement_begin__ = 149;
                        stan::math::assign(rpe_sum, (rpe_sum + (get_base1(get_base1(outcome,i,"outcome",1),t,"outcome",2) - (0.5 * (get_base1(get_base1(gain,i,"gain",1),t,"gain",2) - get_base1(get_base1(loss,i,"loss",1),t,"loss",2))))));
                    }
                    current_statement_begin__ = 152;
                    stan::math::assign(cert_sum, (cert_sum * get_base1(gam,i,"gam",1)));
                    current_statement_begin__ = 153;
                    stan::math::assign(ev_sum, (ev_sum * get_base1(gam,i,"gam",1)));
                    current_statement_begin__ = 154;
                    stan::math::assign(rpe_sum, (rpe_sum * get_base1(gam,i,"gam",1)));
                }
                }
            }

            // validate generated quantities
            current_statement_begin__ = 100;
            current_statement_begin__ = 101;
            current_statement_begin__ = 102;
            current_statement_begin__ = 103;
            current_statement_begin__ = 104;
            check_greater_or_equal(function__,"mu_gam",mu_gam,0);
            check_less_or_equal(function__,"mu_gam",mu_gam,1);
            current_statement_begin__ = 105;
            check_greater_or_equal(function__,"mu_sig",mu_sig,0);
            current_statement_begin__ = 107;
            current_statement_begin__ = 110;

            // write generated quantities
        vars__.push_back(mu_w0);
        vars__.push_back(mu_w1);
        vars__.push_back(mu_w2);
        vars__.push_back(mu_w3);
        vars__.push_back(mu_gam);
        vars__.push_back(mu_sig);
            for (int k_0__ = 0; k_0__ < N; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
            }
            for (int k_1__ = 0; k_1__ < T; ++k_1__) {
                for (int k_0__ = 0; k_0__ < N; ++k_0__) {
                vars__.push_back(y_pred[k_0__][k_1__]);
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_rdt_happiness";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 6; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 6; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "w0_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "w1_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "w2_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "w3_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gam_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sig_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "w0" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "w1" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "w2" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "w3" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "gam" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sig" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_w0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_w1";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_w2";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_w3";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_gam";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_sig";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_pred" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= 6; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "mu_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 6; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigma" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "w0_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "w1_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "w2_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "w3_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gam_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sig_pr" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;

        if (include_tparams__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "w0" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "w1" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "w2" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "w3" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "gam" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sig" << '.' << k_0__;
                param_names__.push_back(param_name_stream__.str());
            }
        }


        if (!include_gqs__) return;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_w0";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_w1";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_w2";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_w3";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_gam";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu_sig";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= T; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= N; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "y_pred" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }

}; // model

}

typedef model_rdt_happiness_namespace::model_rdt_happiness stan_model;


#endif
