% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dataset-Subset.R
\docType{methods}
\name{DataSet-Subset}
\alias{DataSet-Subset}
\alias{[,DataSet,ANY,ANY-method}
\alias{[,DataSet,missing,missing-method}
\alias{[,DataSet,numeric,missing-method}
\alias{[,DataSet,missing,numeric-method}
\alias{[<-,DataSet,missing,missing-method}
\alias{[<-,DataSet,numeric,missing-method}
\alias{[<-,DataSet,missing,numeric-method}
\alias{[<-,DataSet,ANY,ANY-method}
\title{Operators to Subset DataSet Objects}
\usage{
\S4method{[}{DataSet,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{DataSet,missing,missing}(x, i, j, ..., drop = TRUE)

\S4method{[}{DataSet,numeric,missing}(x, i, j, ..., drop = TRUE)

\S4method{[}{DataSet,missing,numeric}(x, i, j, ..., drop = TRUE)

\S4method{[}{DataSet,missing,missing}(x, i, j, ...) <- value

\S4method{[}{DataSet,numeric,missing}(x, i, j, ...) <- value

\S4method{[}{DataSet,missing,numeric}(x, i, j, ...) <- value

\S4method{[}{DataSet,ANY,ANY}(x, i, j, ...) <- value
}
\arguments{
\item{x}{DataSet; S4 object of class \code{DataSet};}

\item{i}{integer; row index}

\item{j}{integer; column index}

\item{...}{additional arguments for subsetting}

\item{drop}{logical; specify if}

\item{value}{object; Value to be assigned to dataset}
}
\description{
\code{\link{DataSet}} objects can be subsetted to retrieve or write sub--regions
as defined by a \code{\link{DataSpace}}. The subsetting command should be 
the same to base R subsetting of vectors, matrices or arrays. Also missing 
subsetting parameters are supported.
}
\details{
For subset--write operations it has to be noted that no recycling is done 
by the function and therefore the written object needs to have the same 
dimensions as the subsetted region.
}
\note{
Subsetting \code{\link{DataSet}}s can become slow for many selection
points since element--wise selection is used, see also \code{\link{DataSpace}}.
}
\examples{
# Write submatrix to sub-region of DataSet
testmat_n <- matrix(as.integer(1:90), ncol = 9)
file <- h5file("test.h5", "a")
file["testgroup/testmat_n2"] <- testmat_n
submat <- matrix(-1L:-9L, nrow = 3)
dset2 <- file["testgroup/testmat_n2"]
dset2[c(1, 3, 5), c(1, 3, 5)] <- submat
h5close(dset2)
h5close(file)
file.remove("test.h5")
}
