% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regions.R
\name{polygonToCells}
\alias{polygonToCells}
\title{Polygon to cells}
\usage{
polygonToCells(polygons, resolution, isLatLng = TRUE)
}
\arguments{
\item{polygons}{A list of polygons. Each polygon is list of matrices.}

\item{resolution}{The resolution of the output cells}

\item{isLatLng}{\code{TRUE} (default) if the coordinates are in \code{lat / lng} order.
\code{FALSE} otherwise}
}
\value{
h3 indexes for the input GeoJSON-like data structure
}
\description{
Returns the h3 indexes for the input GeoJSON-like data structure
}
\examples{

## single polygon
polygon <- list(
  list(
  matrix(
    c(
    37.813318999983238, -122.4089866999972145,
    37.7198061999978478, -122.3544736999993603,
    37.8151571999998453, -122.4798767000009008
    )
    , ncol = 2
    , byrow = TRUE
  )
  )
)

polygonToCells(polygon, resolution = 7L)

## poylgon with a hole
polygon <- list(
list(
  matrix(
    c(
    37.813318999983238, -122.4089866999972145,
    37.7198061999978478, -122.3544736999993603,
    37.8151571999998453, -122.4798767000009008
    )
    , ncol = 2
    , byrow = TRUE
  ),
  matrix(
    c(
    37.813318999983238, -122.4089866999972145,
    37.7198061999978478, -122.3544736999993603,
    37.8151571999998453, -122.4498767000009008
    )
    , ncol = 2
    , byrow = TRUE
  )
)
)

polygonToCells(polygon, resolution = 7L)

## Many polygons
polygon <- list(
  list(
    matrix(
      c(
      37.813318999983238, -122.4089866999972145,
      37.7198061999978478, -122.3544736999993603,
      37.8151571999998453, -122.4798767000009008
      )
      , ncol = 2
      , byrow = TRUE
    )
   ),
 list(
  matrix(
    c(
    37.813318999983238, -122.4089866999972145,
    37.7198061999978478, -122.3544736999993603,
    37.8151571999998453, -122.4498767000009008
    )
    , ncol = 2
    , byrow = TRUE
    )
  )
)

polygonToCells(polygon, resolution = c(7L, 7L))


}
