% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vertexes.R
\name{vertex_to_point}
\alias{vertex_to_point}
\title{Convert H3 cell vertex index to point location}
\usage{
vertex_to_point(h3_vertex = NULL, simple = TRUE)
}
\arguments{
\item{h3_vertex}{Character; vertex address or addresses.}

\item{simple}{Logical; whether to return a vector of outputs or a data frame
containing both inputs and outputs.}
}
\value{
By default, an \code{sfc_POINT} object of \code{length(h3_address)}.
  EPSG:WGS84.
}
\description{
This function takes a H3 cell vertex index and returns its coordinates in
WGS84.
}
\examples{
# Convert this vertex to a point
vertex_to_point('246be8d127ffffff')

}
