% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain.R
\name{h2o.shap_explain_row_plot}
\alias{h2o.shap_explain_row_plot}
\title{SHAP Local Explanation}
\usage{
h2o.shap_explain_row_plot(
  model,
  newdata,
  row_index,
  columns = NULL,
  top_n_features = 10,
  plot_type = c("barplot", "breakdown"),
  contribution_type = c("both", "positive", "negative")
)
}
\arguments{
\item{model}{An H2O tree-based model. This includes Random Forest, GBM and XGboost
only. Must be a binary classification or regression model.}

\item{newdata}{An H2O Frame, used to determine feature contributions.}

\item{row_index}{Instance row index.}

\item{columns}{List of columns or list of indices of columns to show. 
If specified, then the \code{top_n_features} parameter will be ignored.}

\item{top_n_features}{Integer specifying the maximum number of columns to show (ranked by their contributions).
When \code{plot_type = "barplot"}, then \code{top_n_features} features will be chosen
for each contribution_type.}

\item{plot_type}{Either "barplot" or "breakdown".  Defaults to "barplot".}

\item{contribution_type}{When \code{plot_type == "barplot"}, plot one of "negative", 
"positive", or "both" contributions.  Defaults to "both".}
}
\value{
A ggplot2 object.
}
\description{
SHAP explanation shows contribution of features for a given instance. The sum
of the feature contributions and the bias term is equal to the raw prediction
of the model, i.e., prediction before applying inverse link function. H2O implements
TreeSHAP which when the features are correlated, can increase contribution of a feature
that had no influence on the prediction.
}
\examples{
\dontrun{
library(h2o)
h2o.init()

# Import the wine dataset into H2O:
f <- "https://h2o-public-test-data.s3.amazonaws.com/smalldata/wine/winequality-redwhite-no-BOM.csv"
df <-  h2o.importFile(f)

# Set the response
response <- "quality"

# Split the dataset into a train and test set:
splits <- h2o.splitFrame(df, ratios = 0.8, seed = 1)
train <- splits[[1]]
test <- splits[[2]]

# Build and train the model:
gbm <- h2o.gbm(y = response,
               training_frame = train)

# Create the SHAP row explanation plot
shap_explain_row_plot <- h2o.shap_explain_row_plot(gbm, test, row_index = 1)
print(shap_explain_row_plot)
}
}
