% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kvstore.R
\name{h2o.download_model}
\alias{h2o.download_model}
\title{Download the model in binary format.}
\usage{
h2o.download_model(model, path = NULL)
}
\arguments{
\item{model}{An H2OModel}

\item{path}{The path where binary file should be downloaded. Downloaded to current directory by default.}
}
\description{
Download the model in binary format.
}
\examples{
\dontrun{
library(h2o)
h <- h2o.init()
fr <- as.h2o(iris)
my_model <- h2o.gbm(x = 1:4, y = 5, training_frame = fr)
h2o.download_model(my_model)  # save to the current working directory
}
}
