% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/frame.R
\name{h2o.relevel}
\alias{h2o.relevel}
\title{Reorders levels of an H2O factor, similarly to standard R's relevel.}
\usage{
h2o.relevel(x, y)
}
\arguments{
\item{x}{factor column in h2o frame}

\item{y}{reference level (string)}
}
\value{
new reordered factor column
}
\description{
The levels of a factor are reordered os that the reference level is at level 0, remaining levels are moved down as needed.
}
\examples{
\donttest{
library(h2o)
h2o.init()

# Convert iris dataset to an H2OFrame
hf <- as.h2o(iris)
# Look at current ordering of the Species column levels
h2o.levels(hf["Species"])
# "setosa"     "versicolor" "virginica"
# Change the reference level to "virginica"
hf["Species"] <- h2o.relevel(x = hf["Species"], y = "virginica")
# Observe new ordering
h2o.levels(hf["Species"])
# "virginica"  "setosa"     "versicolor"
}
}

