% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.glm}
\alias{h2o.glm}
\title{H2O Generalized Linear Models}
\usage{
h2o.glm(x, y, training_frame, model_id, validation_frame = NULL,
  ignore_const_cols = TRUE, max_iterations = 50, beta_epsilon = 0,
  solver = c("IRLSM", "L_BFGS"), standardize = TRUE,
  family = c("gaussian", "binomial", "poisson", "gamma", "tweedie",
  "multinomial"), link = c("family_default", "identity", "logit", "log",
  "inverse", "tweedie"), tweedie_variance_power = 0, tweedie_link_power = 1,
  alpha = 0.5, prior = NULL, lambda = 1e-05, lambda_search = FALSE,
  early_stopping = FALSE, nlambdas = -1, lambda_min_ratio = -1,
  nfolds = 0, seed = NULL, fold_column = NULL,
  fold_assignment = c("AUTO", "Random", "Modulo", "Stratified"),
  keep_cross_validation_predictions = FALSE,
  keep_cross_validation_fold_assignment = FALSE, beta_constraints = NULL,
  offset_column = NULL, weights_column = NULL, intercept = TRUE,
  max_active_predictors = -1, interactions = NULL, objective_epsilon = -1,
  gradient_epsilon = -1, non_negative = FALSE, compute_p_values = FALSE,
  remove_collinear_columns = FALSE, max_runtime_secs = 0,
  missing_values_handling = c("MeanImputation", "Skip"))
}
\arguments{
\item{x}{A vector containing the names or indices of the predictor variables to use in building the GLM model.
If x is missing,then all columns except y are used.}

\item{y}{A character string or index that represent the response variable in the model.}

\item{training_frame}{An H2OFrame object containing the variables in the model.}

\item{model_id}{(Optional) The unique id assigned to the resulting model. If none is given, an id will automatically be generated.}

\item{validation_frame}{An H2OFrame object containing the variables in the model.  Defaults to NULL.}

\item{ignore_const_cols}{A logical value indicating whether or not to ignore all the constant columns in the training frame.}

\item{max_iterations}{A non-negative integer specifying the maximum number of iterations.}

\item{beta_epsilon}{A non-negative number specifying the magnitude of the maximum difference between the coefficient estimates from successive iterations.
Defines the convergence criterion for \code{h2o.glm}.}

\item{solver}{A character string specifying the solver used: IRLSM (supports more features), L_BFGS (scales better for datasets with many columns)}

\item{standardize}{A logical value indicating whether the numeric predictors should be standardized to have a mean of 0 and a variance of 1 prior to
training the models.}

\item{family}{A character string specifying the distribution of the model:  gaussian, binomial, poisson, gamma, tweedie.}

\item{link}{A character string specifying the link function. The default is the canonical link for the \code{family}. The supported links for each of
the \code{family} specifications are:\cr
\code{"gaussian"}: \code{"identity"}, \code{"log"}, \code{"inverse"}\cr
\code{"binomial"}: \code{"logit"}, \code{"log"}\cr
\code{"poisson"}: \code{"log"}, \code{"identity"}\cr
\code{"gamma"}: \code{"inverse"}, \code{"log"}, \code{"identity"}\cr
\code{"tweedie"}: \code{"tweedie"}\cr}

\item{tweedie_variance_power}{A numeric specifying the power for the variance function when \code{family = "tweedie"}. Default is 0.}

\item{tweedie_link_power}{A numeric specifying the power for the link function when \code{family = "tweedie"}. Default is 1.}

\item{alpha}{A numeric in [0, 1] specifying the elastic-net mixing parameter.
The elastic-net penalty is defined to be:
\deqn{P(\alpha,\beta) = (1-\alpha)/2||\beta||_2^2 + \alpha||\beta||_1 = \sum_j [(1-\alpha)/2 \beta_j^2 + \alpha|\beta_j|]}
making \code{alpha = 1} the lasso penalty and \code{alpha = 0} the ridge penalty.}

\item{prior}{(Optional) A numeric specifying the prior probability of class 1 in the response when \code{family = "binomial"}.
The default prior is the observational frequency of class 1. Must be from (0,1) exclusive range or NULL (no prior).}

\item{lambda}{A non-negative shrinkage parameter for the elastic-net, which multiplies \eqn{P(\alpha,\beta)} in the objective function.
When \code{lambda = 0}, no elastic-net penalty is applied and ordinary generalized linear models are fit.}

\item{lambda_search}{A logical value indicating whether to conduct a search over the space of lambda values starting from the lambda max, given
\code{lambda} is interpreted as lambda min.}

\item{early_stopping}{A logical value indicating whether to stop early when doing lambda search. H2O will stop the computation at the moment when the likelihood stops changing or gets  (on the validation data).}

\item{nlambdas}{The number of lambda values to use when \code{lambda_search = TRUE}. If \code{alpha = 0}, with \code{lambda_search = TRUE},
the value of \code{nlamdas} is set to 30 (fewer lambdas are needed for ridge regression) otherwise it is set to 100.}

\item{lambda_min_ratio}{Smallest value for lambda as a fraction of lambda.max. By default if the number of observations is greater than the
the number of variables then \code{lambda_min_ratio = 0.0001}; if the number of observations is less than the number
of variables then \code{lambda_min_ratio = 0.01}.}

\item{nfolds}{(Optional) Number of folds for cross-validation.}

\item{seed}{(Optional) Specify the random number generator (RNG) seed for cross-validation folds.}

\item{fold_column}{(Optional) Column with cross-validation fold index assignment per observation.}

\item{fold_assignment}{Cross-validation fold assignment scheme, if fold_column is not
specified, must be "AUTO", "Random",  "Modulo", or "Stratified".  The Stratified option will
stratify the folds based on the response variable, for classification problems.}

\item{keep_cross_validation_predictions}{Whether to keep the predictions of the cross-validation models.}

\item{keep_cross_validation_fold_assignment}{Whether to keep the cross-validation fold assignment.}

\item{beta_constraints}{A data.frame or H2OParsedData object with the columns ["names",
"lower_bounds", "upper_bounds", "beta_given", "rho"], where each row corresponds to a predictor
in the GLM. "names" contains the predictor names, "lower_bounds" and "upper_bounds" are the lower
and upper bounds of beta, "beta_given" is some supplied starting values for beta, and "rho" is the
proximal penalty constant that is used with "beta_given". If "rho" is not specified when "beta_given"
is then we will take the default rho value of zero.}

\item{offset_column}{Specify the offset column.}

\item{weights_column}{Specify the weights column.}

\item{intercept}{Logical, include constant term (intercept) in the model.}

\item{max_active_predictors}{(Optional) Convergence criteria for number of predictors when using L1 penalty. If
the IRLSM solver is used, the value of \code{max_active_predictors} is set to 7000 otherwise it is set to 100000000.}

\item{interactions}{A vector of column indices to interact pairwise. All combinations of two indices will be computed.}

\item{objective_epsilon}{Convergence criteria. Converge if relative change in objective function is below this threshold.
If \code{lambda_search = TRUE} the value of \code{objective_epsilon} is set to .0001. If the \code{lambda_search = False}
and \code{lambda = 0}, the value of \code{objective_epsilon} is set to .000001, for any other value of lambda the value of \code{objective_epsilon} is set to .0001.}

\item{gradient_epsilon}{Convergence criteria. Converge if gradient l-infinity norm is below this threshold. If
\code{lambda_search = FALSE} and \code{lambda = 0}, the default value of gradient_epsilon is equal to
.000001, otherwise the default value is .0001. If \code{lambda_search = TRUE}, the conditional values above are 1E-8 and 1E-6 respectively.}

\item{non_negative}{Logical, allow only positive coefficients.}

\item{compute_p_values}{(Optional)  Logical, compute p-values, only allowed with IRLSM solver and no regularization. May fail if there are collinear predictors.}

\item{remove_collinear_columns}{(Optional)  Logical, valid only with no regularization. If set, co-linear columns will be automatically ignored (coefficient will be 0).}

\item{max_runtime_secs}{Maximum allowed runtime in seconds for model training. Use 0 to disable.}

\item{missing_values_handling}{(Optional) Controls handling of missing values. Can be either "MeanImputation" or "Skip". MeanImputation replaces missing values with mean for numeric and most frequent level for categorical,  Skip ignores observations with any missing value. Applied both during model training *AND* scoring.}
}
\value{
A subclass of \code{\linkS4class{H2OModel}} is returned. The specific subclass depends on the machine learning task at hand
        (if it's binomial classification, then an \code{\linkS4class{H2OBinomialModel}} is returned, if it's regression then a
         \code{\linkS4class{H2ORegressionModel}} is returned). The default print-out of the models is shown, but further GLM-specifc
         information can be queried out of the object. To access these various items, please refer to the seealso section below.

         Upon completion of the GLM, the resulting object has coefficients, normalized coefficients, residual/null deviance, aic,
         and a host of model metrics including MSE, AUC (for logistic regression), degrees of freedom, and confusion matrices. Please
         refer to the more in-depth GLM documentation available here: \url{http://h2o-release.s3.amazonaws.com/h2o-dev/rel-shannon/2/docs-website/h2o-docs/index.html#Data+Science+Algorithms-GLM},
}
\description{
Fit a generalized linear model, specified by a response variable, a set of predictors, and a description of the error distribution.
}
\examples{
\donttest{
h2o.init()

# Run GLM of CAPSULE ~ AGE + RACE + PSA + DCAPS
prostatePath = system.file("extdata", "prostate.csv", package = "h2o")
prostate.hex = h2o.importFile(path = prostatePath, destination_frame = "prostate.hex")
h2o.glm(y = "CAPSULE", x = c("AGE","RACE","PSA","DCAPS"), training_frame = prostate.hex,
        family = "binomial", nfolds = 0, alpha = 0.5, lambda_search = FALSE)

# Run GLM of VOL ~ CAPSULE + AGE + RACE + PSA + GLEASON
myX = setdiff(colnames(prostate.hex), c("ID", "DPROS", "DCAPS", "VOL"))
h2o.glm(y = "VOL", x = myX, training_frame = prostate.hex, family = "gaussian",
        nfolds = 0, alpha = 0.1, lambda_search = FALSE)


# GLM variable importance
# Also see:
#   https://github.com/h2oai/h2o/blob/master/R/tests/testdir_demos/runit_demo_VI_all_algos.R
data.hex = h2o.importFile(
  path = "https://s3.amazonaws.com/h2o-public-test-data/smalldata/demos/bank-additional-full.csv",
  destination_frame = "data.hex")
myX = 1:20
myY="y"
my.glm = h2o.glm(x=myX, y=myY, training_frame=data.hex, family="binomial", standardize=TRUE,
                 lambda_search=TRUE)
}
}
\seealso{
\code{\link{predict.H2OModel}} for prediction, \code{\link{h2o.mse}}, \code{\link{h2o.auc}},
         \code{\link{h2o.confusionMatrix}}, \code{\link{h2o.performance}}, \code{\link{h2o.giniCoef}}, \code{\link{h2o.logloss}},
         \code{\link{h2o.varimp}}, \code{\link{h2o.scoreHistory}}
}

