% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdelaunay.R
\name{plotHdelaunay}
\alias{plotHdelaunay}
\title{Plot hyperbolic Delaunay triangulation}
\usage{
plotHdelaunay(
  hdel,
  remove = NULL,
  vertices = TRUE,
  edges = TRUE,
  circle = TRUE,
  color = "distinct",
  hue = "random",
  luminosity = "random"
)
}
\arguments{
\item{hdel}{an output of \code{\link{hdelaunay}}}

\item{remove}{what you want to remove, \code{NULL} for nothing,
\code{"ivertices"} for the isolated vertices, \code{"iedges"}
for the isolated edges or \code{c("ivertices", "iedges")} for
the isolated vertices and the isolated edges; if not \code{NULL},
this assumes you ran \code{\link{hdelaunay}} with the
option \code{isolations=TRUE}}

\item{vertices}{Boolean, whether to plot the vertices}

\item{edges}{Boolean, whether to plot the edges}

\item{circle}{Boolean, whether to plot the unit circle}

\item{color}{this argument controls the colors of the triangles; it can be
\code{NA} for no color, \code{"random"} for random colors generated
with \code{\link[randomcoloR]{randomColor}}, \code{"distinct"} for
distinct colors generated with
\code{\link[randomcoloR]{distinctColorPalette}}, a single color,
a vector of colors (color \code{i} attributed to the \code{i}-th
triangle), or a vectorized function mapping each point in the unit
interval to a color}

\item{hue, luminosity}{passed to \code{\link[randomcoloR]{randomColor}}
if \code{color="random"}}
}
\value{
No returned value.
}
\description{
Plot a hyperbolic Delaunay triangulation obtained
  with \code{\link{hdelaunay}}.
}
\examples{
library(gyro)
library(uniformly)
set.seed(666)
points <- runif_in_sphere(35L, d = 2)
hdel <- hdelaunay(points, exact = TRUE)
plotHdelaunay(hdel)

# example with colors given by a function ####
library(gyro)
library(trekcolors)

phi <- (1 + sqrt(5)) / 2
theta <- head(seq(0, pi/2, length.out = 11), -1L)
a <- phi^((2*theta/pi)^0.8 - 1)
u <- a * cos(theta)
v <- a * sin(theta)
x <- c(0, u, -v, -u, v)
y <- c(0, v, u, -v, -u)
pts <- cbind(x, y) / 1.03

hdel <- hdelaunay(pts, centroids = TRUE, exact = TRUE)

fcolor <- function(t){
  RGB <- colorRamp(trek_pal("klingon"))(t)
  rgb(RGB[, 1L], RGB[, 2L], RGB[, 3L], maxColorValue = 255)
}

plotHdelaunay(
  hdel, vertices = FALSE, circle = FALSE, color = fcolor
)
}
