% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_xlsx.R
\name{write_xlsx}
\alias{write_xlsx}
\title{Export a GWAS Catalog object to xlsx}
\usage{
write_xlsx(x, file = stop("`file` must be specified"))
}
\arguments{
\item{x}{A \linkS4class{studies}, \linkS4class{associations},
\linkS4class{variants} or \linkS4class{traits} object.}

\item{file}{A file name to write to.}
}
\value{
Although this function is run for its side effect of writing an xlsx
  file, the path to the exported file is returned.
}
\description{
This function exports a GWAS Catalog object to Microsoft Excel xlsx file.
Each table (slot) is saved in its own sheet.
}
\examples{
# Initial setup
.old_wd <- setwd(tempdir())

# Save an `associations` object, e.g. `associations_ex01`, to xlsx.
write_xlsx(associations_ex01, "associations.xlsx")

# Cleanup
unlink("associations.xlsx")
setwd(.old_wd)

}
