% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_strata_nested_stack.R
\name{tbl_strata_nested_stack}
\alias{tbl_strata_nested_stack}
\title{Stratified Nested Stacking}
\usage{
tbl_strata_nested_stack(
  data,
  strata,
  .tbl_fun,
  ...,
  row_header = "{strata}",
  quiet = FALSE
)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame}

\item{strata}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
character vector or tidy-selector of columns in data to stratify results by.
Only \emph{observed} combinations are shown in results.}

\item{.tbl_fun}{(\code{function})
A function or formula. If a \emph{function}, it is used as is.
If a formula, e.g. \code{~ .x \%>\% tbl_summary() \%>\% add_p()}, it is converted to a function.
The stratified data frame is passed to this function.}

\item{...}{Additional arguments passed on to the \code{.tbl_fun} function.}

\item{row_header}{(\code{string})\cr
string indicating the row headers that appear in the table.
The argument uses \code{glue::glue()} syntax to insert values into the
row headers. Elements available to insert are \code{strata}, \code{n}, \code{N} and \code{p}.
The \code{strata} element is the variable level of the strata variables.
Default is \code{'{strata}'}.}

\item{quiet}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\value{
a stacked 'gtsummary' table
}
\description{
This function stratifies your data frame, builds gtsummary tables, and
stacks the resulting tables in a nested style. The underlying functionality
is similar to \code{tbl_strata()}, except the resulting tables are nested or indented
within each group.
}
\examples{
# Example 1 ----------------------------------
tbl_strata_nested_stack(
  trial,
  strata = trt,
  .tbl_fun = ~ .x |>
    tbl_summary(include = c(age, grade), missing = "no") |>
    modify_header(all_stat_cols() ~ "**Summary Statistics**")
)

# Example 2 ----------------------------------
tbl_strata_nested_stack(
  trial,
  strata = trt,
  .tbl_fun = ~ .x |>
    tbl_summary(include = c(age, grade), missing = "no") |>
    modify_header(all_stat_cols() ~ "**Summary Statistics**"),
  row_header = "{strata}, n={n}"
) |>
  # bold the row headers; print `x$table_body` to see hidden columns
  modify_bold(columns = "label", rows = tbl_indent_id1 > 0)
}
