% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_ard_wide_summary.R
\name{tbl_ard_wide_summary}
\alias{tbl_ard_wide_summary}
\title{Wide ARD summary table}
\usage{
tbl_ard_wide_summary(
  cards,
  statistic = switch(type[[1]], continuous = c("{median}", "{p25}, {p75}"), c("{n}",
    "{p}\%")),
  type = NULL,
  value = NULL,
  include = everything()
)
}
\arguments{
\item{cards}{(\code{card})\cr
An ARD object of class \code{"card"} typically created with \verb{cards::ard_*()} functions.}

\item{statistic}{(\code{character})\cr
character vector of the statistics to present. Each element of the vector
will result in a column in the summary table. Default is
\code{c("{median}", "{p25}, {p75}")} for continuous summaries, and
\code{c("{n}", "{p}\%")} for categorical/dichotomous summaries}

\item{type}{(\code{\link[=syntax]{formula-list-selector}})\cr
Specifies the summary type. Accepted value are
\code{c("continuous", "continuous2", "categorical", "dichotomous")}.
If not specified, default type is assigned via
\code{assign_summary_type()}. See below for details.}

\item{value}{(\code{\link[=syntax]{formula-list-selector}})\cr
Specifies the level of a variable to display on a single row.
The gtsummary type selectors, e.g. \code{all_dichotomous()}, cannot be used
with this argument. Default is \code{NULL}. See below for details.}

\item{include}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Variables to include in the summary table. Default is \code{everything()}.}
}
\value{
a gtsummary table of class 'tbl_wide_summary'
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}\cr
This function is similar to \code{tbl_ard_summary()}, but places summary statistics
wide, in separate columns.
All included variables must be of the same summary type, e.g. all continuous
summaries or all categorical summaries (which encompasses dichotomous variables).
}
\examples{
library(cards)

ard_stack(
  trial,
  ard_continuous(variables = age),
  .missing = TRUE,
  .attributes = TRUE
) |>
  tbl_ard_wide_summary()

ard_stack(
  trial,
  ard_dichotomous(variables = response),
  ard_categorical(variables = grade),
  .missing = TRUE,
  .attributes = TRUE
) |>
  tbl_ard_wide_summary()
}
