% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_stack.R
\name{tbl_stack}
\alias{tbl_stack}
\title{Stacks two or more gtsummary objects}
\usage{
tbl_stack(tbls)
}
\arguments{
\item{tbls}{List of gtsummary objects}
}
\value{
A \code{tbl_stack} object
}
\description{
Assists in patching together more complex tables. \code{tbl_stack()} appends two
or more \code{tbl_regression}, \code{tbl_summary}, or \code{tbl_merge} objects.
{gt} attributes from the first regression object are utilized for output
table.
}
\section{Example Output}{

\if{html}{Example 1}

\if{html}{\figure{tbl_stack_ex1.png}{options: width=50\%}}

\if{html}{Example 2}

\if{html}{\figure{tbl_stack_ex2.png}{options: width=80\%}}
}

\examples{
# Example 1 - stacking two tbl_regression objects
t1 <-
  glm(response ~ trt, trial, family = binomial) \%>\%
  tbl_regression(
    exponentiate = TRUE,
    label = list(trt ~ "Treatment (unadjusted)")
  )

t2 <-
  glm(response ~ trt + grade + stage + marker, trial, family = binomial) \%>\%
  tbl_regression(
    include = "trt",
    exponentiate = TRUE,
    label = list(trt ~ "Treatment (adjusted)")
  )

tbl_stack_ex1 <- tbl_stack(list(t1, t2))

# Example 2 - stacking two tbl_merge objects
library(survival)
t3 <-
  coxph(Surv(ttdeath, death) ~ trt, trial) \%>\%
  tbl_regression(
    exponentiate = TRUE,
    label = list(trt ~ "Treatment (unadjusted)")
  )

t4 <-
  coxph(Surv(ttdeath, death) ~ trt + grade + stage + marker, trial) \%>\%
  tbl_regression(
    include = "trt",
    exponentiate = TRUE,
    label = list(trt ~ "Treatment (adjusted)")
  )


# first merging, then stacking
row1 <- tbl_merge(list(t1, t3), tab_spanner = c("Tumor Response", "Death"))
row2 <- tbl_merge(list(t2, t4))
tbl_stack_ex2 <-
  tbl_stack(list(row1, row2))
}
\seealso{
\link{tbl_merge}

Other tbl_summary tools: 
\code{\link{add_n}()},
\code{\link{add_overall}()},
\code{\link{add_p}()},
\code{\link{add_q.tbl_summary}()},
\code{\link{add_stat_label}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{bold_p.tbl_summary}()},
\code{\link{inline_text.tbl_summary}()},
\code{\link{modify_header}()},
\code{\link{sort_p.tbl_summary}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_summary}()}

Other tbl_regression tools: 
\code{\link{add_global_p.tbl_regression}()},
\code{\link{add_nevent.tbl_regression}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{bold_p.tbl_regression}()},
\code{\link{bold_p.tbl_stack}()},
\code{\link{combine_terms}()},
\code{\link{inline_text.tbl_regression}()},
\code{\link{modify_header}()},
\code{\link{sort_p.tbl_regression}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_regression}()}

Other tbl_uvregression tools: 
\code{\link{add_global_p.tbl_uvregression}()},
\code{\link{add_nevent.tbl_uvregression}()},
\code{\link{add_q.tbl_uvregression}()},
\code{\link{bold_italicize_labels_levels}},
\code{\link{bold_p.tbl_stack}()},
\code{\link{bold_p.tbl_uvregression}()},
\code{\link{inline_text.tbl_uvregression}()},
\code{\link{modify_header}()},
\code{\link{sort_p.tbl_uvregression}()},
\code{\link{tbl_merge}()},
\code{\link{tbl_uvregression}()}
}
\author{
Daniel D. Sjoberg
}
\concept{tbl_regression tools}
\concept{tbl_summary tools}
\concept{tbl_uvregression tools}
