% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style_ratio.R
\name{style_ratio}
\alias{style_ratio}
\title{Implement significant figure-like rounding for ratios}
\usage{
style_ratio(x, digits = 2)
}
\arguments{
\item{x}{Numeric vector}

\item{digits}{Integer specifying the number of significant
digits to display for numbers below 1. Numbers larger than 1 will be be \code{digits + 1}.
Default is \code{digits = 2}.}
}
\value{
A character vector of styled ratios
}
\description{
When reporting ratios, such as relative risk or an odds ratio, we'll often
want the rounding to be similar on each side of the number 1.  For example,
if we report an odds ratio of 0.95 with a confidence interval of 0.70 to 1.24,
we would want to round to two decimal places for all values. In other words,
2 significant figures for numbers less than 1 and 3 significant figures 1 and
larger. \code{style_ratio()} performs significant figure-like rounding in this manner.
}
\examples{
c(
  0.123, 0.9, 1.1234, 12.345, 101.234, -0.123,
  -0.9, -1.1234, -12.345, -101.234
) \%>\%
  style_ratio()
}
\seealso{
\link{style_sigfig}
}
\author{
Daniel D. Sjoberg
}
