% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-create_header.R
\name{create_header}
\alias{create_header}
\title{Creates header rows for \code{fmt_table1} of \code{fmt_regression} objects}
\usage{
create_header(data = NULL, by = NULL, mod = NULL, label = NULL,
  stat_by = NULL, stat_overall = NULL, pvalue = NULL, est = NULL,
  ci = NULL, N = NULL)
}
\arguments{
\item{data}{data frame. \code{fmt_table1} only.}

\item{by}{string of column name in data. \code{fmt_table1} only.}

\item{mod}{regression model object. \code{fmt_regression} only.}

\item{label}{string vector including text to appear above the label column.
\code{fmt_table1} and \code{fmt_regression}.}

\item{stat_by}{string vector of text to include above the summary statistics
stratified by a variable.  The following fields are available for use in the
headers: \code{n}, \code{N}, \code{p}, \code{name}, \code{label}, and \code{level}.  \code{n} is the number of observations in
each by group. \code{N} is the total number of observations. \code{p} is the percentage of rows
in a by group. \code{name} is the name of the by variable. \code{level} is the by variable level.
Must specify 'by' along with 'stat_by'. \code{fmt_table1} only.}

\item{stat_overall}{string vector including text to appear above the overall summary
statistics. \code{N}, the total number of observations, is available for use in the
description. \code{fmt_table1} only}

\item{pvalue}{string vector including text to appear above the p-value column.
\code{fmt_table1} and \code{fmt_regression}.}

\item{est}{string vector including text to appear above the coefficient column.
\code{fmt_regression} only.}

\item{ci}{string vector including text to appear above the confidence interval
column. \code{fmt_regression} only.}

\item{N}{string vector including text to appear above the N column}
}
\description{
This function takes in a data frame and information to include in the header
rows.  The user will rarely call this function directly, rather they will use a
wrapper for this function \code{modify_header()}.
}
\keyword{internal}
