% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_stat_label.R
\name{add_stat_label}
\alias{add_stat_label}
\title{Adds a column showing a label for the summary statistics shown in each row}
\usage{
add_stat_label(x, iqr = TRUE)
}
\arguments{
\item{x}{object with class \code{fmt_table1} from the \code{\link{fmt_table1}} function}

\item{iqr}{logical indicator whether '{q1}, {q2}' and '{p25}, {p75}' should
resolve to 'IQR'. Default is \code{TRUE}}
}
\description{
Rather than simply printing the summary statistics, with the use of \code{add_stat_label()},
a column labeling the summary statistics is added.
}
\examples{
mtcars \%>\% fmt_table1() \%>\% add_stat_label()
mtcars \%>\% fmt_table1(by = "am") \%>\% add_stat_label(iqr = FALSE)
}
