% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_median_junction_expression.R
\name{get_median_junction_expression}
\alias{get_median_junction_expression}
\title{Get Median Junction Expression}
\usage{
get_median_junction_expression(
  gencodeIds,
  datasetId = "gtex_v8",
  tissueSiteDetailIds = NULL,
  page = 0,
  itemsPerPage = getOption("gtexr.itemsPerPage"),
  .verbose = getOption("gtexr.verbose"),
  .return_raw = FALSE
)
}
\arguments{
\item{gencodeIds}{A character vector of Versioned GENCODE IDs, e.g.
c("ENSG00000132693.12", "ENSG00000203782.5").}

\item{datasetId}{String. Unique identifier of a dataset. Usually includes a
data source and data release. Options: "gtex_v8", "gtex_snrnaseq_pilot".}

\item{tissueSiteDetailIds}{Character vector of IDs for tissues of interest.
Can be GTEx specific IDs (e.g. "Whole_Blood"; use
\code{\link[=get_tissue_site_detail]{get_tissue_site_detail()}} to see valid values) or Ontology IDs.}

\item{page}{Integer (default = 0).}

\item{itemsPerPage}{Integer (default = 250). Set globally to maximum value
100000 with \code{options(list(gtexr.itemsPerPage = 100000))}.}

\item{.verbose}{Logical. If \code{TRUE} (default), print paging information. Set
to \code{FALSE} globally with \code{options(list(gtexr.verbose = FALSE))}.}

\item{.return_raw}{Logical. If \code{TRUE}, return the raw API JSON response.
Default = \code{FALSE}}
}
\value{
A tibble. Or a list if \code{.return_raw = TRUE}.
}
\description{
Find junction gene expression data.
\itemize{
\item Returns median junction read counts in tissues of a given gene from all known transcripts.
\item Results may be filtered by dataset or tissue.
}

By default, this service queries the latest GTEx release.

\href{https://gtexportal.org/api/v2/redoc#tag/Expression-Data-Endpoints/operation/get_median_junction_expression_api_v2_expression_medianJunctionExpression_get}{GTEx Portal API documentation}
}
\examples{
\dontrun{
get_median_junction_expression(gencodeIds = "ENSG00000132693.12")
}
}
\seealso{
Other Expression Data Endpoints: 
\code{\link{get_clustered_median_exon_expression}()},
\code{\link{get_clustered_median_gene_expression}()},
\code{\link{get_clustered_median_junction_expression}()},
\code{\link{get_clustered_median_transcript_expression}()},
\code{\link{get_expression_pca}()},
\code{\link{get_gene_expression}()},
\code{\link{get_median_exon_expression}()},
\code{\link{get_median_gene_expression}()},
\code{\link{get_median_transcript_expression}()},
\code{\link{get_single_nucleus_gex}()},
\code{\link{get_single_nucleus_gex_summary}()},
\code{\link{get_top_expressed_genes}()}
}
\concept{Expression Data Endpoints}
