% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_vec.R
\name{vec_fmt_percent}
\alias{vec_fmt_percent}
\title{Format a vector as percentage values}
\usage{
vec_fmt_percent(
  x,
  decimals = 2,
  drop_trailing_zeros = FALSE,
  drop_trailing_dec_mark = TRUE,
  scale_values = TRUE,
  use_seps = TRUE,
  accounting = FALSE,
  pattern = "{x}",
  sep_mark = ",",
  dec_mark = ".",
  force_sign = FALSE,
  incl_space = FALSE,
  placement = "right",
  locale = NULL,
  output = c("auto", "plain", "html", "latex", "rtf", "word")
)
}
\arguments{
\item{x}{A numeric vector.}

\item{decimals}{An option to specify the exact number of decimal places to
use. The default number of decimal places is \code{2}.}

\item{drop_trailing_zeros}{A logical value that allows for removal of
trailing zeros (those redundant zeros after the decimal mark).}

\item{drop_trailing_dec_mark}{A logical value that determines whether decimal
marks should always appear even if there are no decimal digits to display
after formatting (e.g, \code{23} becomes \code{23.}). The default for this is \code{TRUE},
which means that trailing decimal marks are not shown.}

\item{scale_values}{Should the values be scaled through multiplication by
100? By default this is \code{TRUE} since the expectation is that normally
values are proportions. Setting to \code{FALSE} signifies that the values are
already scaled and require only the percent sign when formatted.}

\item{use_seps}{An option to use digit group separators. The type of digit
group separator is set by \code{sep_mark} and overridden if a locale ID is
provided to \code{locale}. This setting is \code{TRUE} by default.}

\item{accounting}{An option to use accounting style for values. With \code{FALSE}
(the default), negative values will be shown with a minus sign. Using
\code{accounting = TRUE} will put negative values in parentheses.}

\item{pattern}{A formatting pattern that allows for decoration of the
formatted value. The value itself is represented by \code{{x}} and all other
characters are taken to be string literals.}

\item{sep_mark}{The mark to use as a separator between groups of digits
(e.g., using \code{sep_mark = ","} with \code{1000} would result in a formatted value
of \verb{1,000}).}

\item{dec_mark}{The character to use as a decimal mark (e.g., using
\code{dec_mark = ","} with \code{0.152} would result in a formatted value of
\verb{0,152}).}

\item{force_sign}{Should the positive sign be shown for positive values
(effectively showing a sign for all values except zero)? If so, use \code{TRUE}
for this option. The default is \code{FALSE}, where only negative numbers will
display a minus sign. This option is disregarded when using accounting
notation with \code{accounting = TRUE}.}

\item{incl_space}{An option for whether to include a space between the value
and the percent sign. The default is to not introduce a space character.}

\item{placement}{The placement of the percent sign. This can be either be
\code{right} (the default) or \code{left}.}

\item{locale}{An optional locale ID that can be used for formatting the value
according the locale's rules. Examples include \code{"en"} for English (United
States) and \code{"fr"} for French (France). The use of a valid locale ID will
override any values provided in \code{sep_mark} and \code{dec_mark}. We can use the
\code{\link[=info_locales]{info_locales()}} function as a useful reference for all of the locales that
are supported.}

\item{output}{The output style of the resulting character vector. This can
either be \code{"auto"} (the default), \code{"plain"}, \code{"html"}, \code{"latex"}, \code{"rtf"},
or \code{"word"}. In \strong{knitr} rendering (i.e., Quarto or R Markdown), the
\code{"auto"} option will choose the correct \code{output} value}
}
\value{
A character vector.
}
\description{
With numeric values in vector, we can perform percentage-based formatting. It
is assumed that numeric values in the input vector are proportional values
and, in this case, the values will be automatically multiplied by \code{100}
before decorating with a percent sign (the other case is accommodated though
setting the \code{scale_values} to \code{FALSE}). For more control over percentage
formatting, we can use the following options:
\itemize{
\item percent sign placement: the percent sign can be placed after or
before the values and a space can be inserted between the symbol and the
value.
\item decimals: choice of the number of decimal places, option to drop
trailing zeros, and a choice of the decimal symbol
\item digit grouping separators: options to enable/disable digit separators
and provide a choice of separator symbol
\item pattern: option to use a text pattern for decoration of the formatted
values
\item locale-based formatting: providing a locale ID will result in number
formatting specific to the chosen locale
}
}
\section{Examples}{


Let's create a numeric vector for the next few examples:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{num_vals <- c(0.0052, 0.08, 0, -0.535, NA)
}\if{html}{\out{</div>}}

Using \code{vec_fmt_percent()} with the default options will create a character
vector where the resultant percentage values have two decimal places and \code{NA}
values will render as \code{"NA"}. The rendering context will be autodetected
unless specified in the \code{output} argument (here, it is of the \code{"plain"}
output type).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_percent(num_vals)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "0.52\%" "8.00\%" "0.00\%" "-53.50\%" "NA"
}\if{html}{\out{</div>}}

We can change the decimal mark to a comma, and we have to be sure to change
the digit separator mark from the default comma to something else (a period
works here):

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_percent(num_vals, sep_mark = ".", dec_mark = ",")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "0,52\%" "8,00\%" "0,00\%" "-53,50\%" "NA"
}\if{html}{\out{</div>}}

If we are formatting for a different locale, we could supply the locale ID
and let \strong{gt} handle these locale-specific formatting options:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_percent(num_vals, locale = "pt")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "0,52\%" "8,00\%" "0,00\%" "-53,50\%" "NA"
}\if{html}{\out{</div>}}

There are many options for formatting values. Perhaps you need to have
explicit positive and negative signs? Use \code{force_sign = TRUE} for that.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_percent(num_vals, force_sign = TRUE)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "+0.52\%" "+8.00\%" "0.00\%" "-53.50\%" "NA"
}\if{html}{\out{</div>}}

Those trailing zeros past the decimal mark can be stripped out by using the
\code{drop_trailing_zeros} option.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_percent(num_vals, drop_trailing_zeros = TRUE)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "0.52\%" "8\%" "0\%" "-53.5\%" "NA"
}\if{html}{\out{</div>}}

As a last example, one can wrap the values in a pattern with the \code{pattern}
argument. Note here that \code{NA} values won't have the pattern applied.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_percent(num_vals, pattern = "\{x\}wt")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "0.52\%wt" "8.00\%wt" "0.00\%wt" "-53.50\%wt" "NA"
}\if{html}{\out{</div>}}
}

\section{Function ID}{

14-5
}

\seealso{
Other vector formatting functions: 
\code{\link{vec_fmt_bytes}()},
\code{\link{vec_fmt_currency}()},
\code{\link{vec_fmt_datetime}()},
\code{\link{vec_fmt_date}()},
\code{\link{vec_fmt_duration}()},
\code{\link{vec_fmt_engineering}()},
\code{\link{vec_fmt_fraction}()},
\code{\link{vec_fmt_integer}()},
\code{\link{vec_fmt_markdown}()},
\code{\link{vec_fmt_number}()},
\code{\link{vec_fmt_partsper}()},
\code{\link{vec_fmt_roman}()},
\code{\link{vec_fmt_scientific}()},
\code{\link{vec_fmt_time}()}
}
\concept{vector formatting functions}
