% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{opt_table_font}
\alias{opt_table_font}
\title{Option to define a custom font for the table}
\usage{
opt_table_font(data, font, weight = NULL, style = NULL, add = TRUE)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{font}{Either the name of a font available in the user system or a call
to \code{\link[=google_font]{google_font()}}, which has a large selection of typefaces.}

\item{weight}{The weight of the font. Can be a text-based keyword such as
\code{"normal"}, \code{"bold"}, \code{"lighter"}, \code{"bolder"}, or, a numeric value between
\code{1} and \code{1000}, inclusive. Note that only variable fonts may support the
numeric mapping of weight.}

\item{style}{The text style. Can be one of either \code{"normal"}, \code{"italic"}, or
\code{"oblique"}.}

\item{add}{Should this font be added to the front of the already-defined
fonts for the table? By default, this is \code{TRUE} and is recommended since
the list serves as fallbacks when certain fonts are not available.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{opt_table_font()} function makes it possible to define a custom font for
the entire \strong{gt} table. The standard fallback fonts are still set by default
but the font defined here will take precedence. You could still have
different fonts in select locations in the table, and for that you would need
to use \code{\link[=tab_style]{tab_style()}} in conjunction with the \code{\link[=cell_text]{cell_text()}} helper function.
}
\details{
We have the option to supply either a system font for the \code{font_name}, or, a
font available at the Google Fonts service by use of the \code{\link[=google_font]{google_font()}}
helper function.
}
\section{Figures}{

\if{html}{\figure{man_opt_table_font_1.png}{options: width=100\%}}

\if{html}{\figure{man_opt_table_font_2.png}{options: width=100\%}}
}

\section{Function ID}{

9-9
}

\examples{
if (interactive()) {

# Use `sp500` to create a small gt table,
# using `fmt_currency()` to provide a
# dollar sign for the first row of monetary
# values; then, set a larger font size for
# the table and use the 'Merriweather' font
# (from Google Fonts, via `google_font()`)
# with two font fallbacks ('Cochin' and the
# catchall 'Serif' group)
tab_1 <-
  sp500 \%>\%
  dplyr::slice(1:10) \%>\%
  dplyr::select(-volume, -adj_close) \%>\%
  gt() \%>\%
  fmt_currency(
    columns = 2:5,
    rows = 1,
    currency = "USD",
    use_seps = FALSE
  ) \%>\%
  tab_options(table.font.size = px(18)) \%>\%
  opt_table_font(
    font = list(
      google_font(name = "Merriweather"),
      "Cochin", "Serif"
    )
  )

# Use `sza` to create an eleven-row table;
# within `opt_table_font()`, set up a
# preferred list of sans-serif fonts that
# are commonly available in macOS (using
# part of the `default_fonts()` vector as
# a fallback)
# and Windows 10
tab_2 <-
  sza \%>\%
  dplyr::filter(
    latitude == 20 &
      month == "jan" &
      !is.na(sza)
  ) \%>\%
  dplyr::select(-latitude, -month) \%>\%
  gt() \%>\%
  opt_table_font(
    font = c(
      "Helvetica Neue", "Segoe UI",
      default_fonts()[-c(1:3)]
    )
  ) \%>\%
  opt_all_caps()

}

}
\seealso{
Other Table Option Functions: 
\code{\link{opt_align_table_header}()},
\code{\link{opt_all_caps}()},
\code{\link{opt_css}()},
\code{\link{opt_footnote_marks}()},
\code{\link{opt_horizontal_padding}()},
\code{\link{opt_row_striping}()},
\code{\link{opt_table_lines}()},
\code{\link{opt_table_outline}()},
\code{\link{opt_vertical_padding}()}
}
\concept{Table Option Functions}
