% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_create_modify.R
\name{tab_row_group}
\alias{tab_row_group}
\title{Add a row group to a \strong{gt} table}
\usage{
tab_row_group(data, group = NULL, rows = NULL, others = NULL)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{group}{The name of the row group. This text will also serve as the row
group label.}

\item{rows}{The rows to be made components of the row group. Can either be a
vector of row captions provided in \code{c()}, a vector of row indices, or a
helper function focused on selections. The select helper functions are:
\code{\link[=starts_with]{starts_with()}}, \code{\link[=ends_with]{ends_with()}}, \code{\link[=contains]{contains()}}, \code{\link[=matches]{matches()}}, \code{\link[=one_of]{one_of()}}, and
\code{\link[=everything]{everything()}}.}

\item{others}{An option to set a default row group label for any rows not
formally placed in a row group named by \code{group} in any call of
\code{tab_row_group()}. A separate call to \code{tab_row_group()} with only a value
to \code{others} is possible and makes explicit that the call is meant to
provide a default row group label. If this is not set and there are rows
that haven't been placed into a row group (where one or more row groups
already exist), those rows will be automatically placed into a row group
without a label.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Create a row group with a collection of rows. This requires specification of
the rows to be included, either by supplying row labels, row indices, or
through use of a select helper function like \code{starts_with()}.
}
\section{Figures}{

\if{html}{\figure{man_tab_row_group_1.png}{options: width=100\%}}

\if{html}{\figure{man_tab_row_group_2.png}{options: width=100\%}}
}

\section{Function ID}{

2-4
}

\examples{
# Use `gtcars` to create a gt table and
# add two row groups with the labels:
# `numbered` and `NA` (a group without
# a title, or, the rest)
tab_1 <-
  gtcars \%>\%
  dplyr::select(model, year, hp, trq) \%>\%
  dplyr::slice(1:8) \%>\%
  gt(rowname_col = "model") \%>\%
  tab_row_group(
    group = "numbered",
    rows = matches("^[0-9]")
  )

# Use `gtcars` to create a gt table;
# add two row groups with the labels
# `powerful` and `super powerful`: the
# distinction being `hp` lesser or
# greater than `600`
tab_2 <-
  gtcars \%>\%
  dplyr::select(model, year, hp, trq) \%>\%
  dplyr::slice(1:8) \%>\%
  gt(rowname_col = "model") \%>\%
  tab_row_group(
    group = "powerful",
    rows = hp <= 600
  ) \%>\%
  tab_row_group(
    group = "super powerful",
    rows = hp > 600
  )

}
\seealso{
Other Create or Modify Parts: 
\code{\link{tab_footnote}()},
\code{\link{tab_header}()},
\code{\link{tab_options}()},
\code{\link{tab_source_note}()},
\code{\link{tab_spanner_delim}()},
\code{\link{tab_spanner}()},
\code{\link{tab_stubhead}()},
\code{\link{tab_style}()}
}
\concept{Create or Modify Parts}
